<?php
use Livewire\Component;
?>

<section class="pricing-creative-section {{ $isWhiteBackground ? 'pricing-creative-white' : 'pricing-creative-gray' }}"
    @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="pricing-creative-bg">
        <svg class="pricing-creative-blob pricing-creative-blob-1" viewBox="0 0 200 200"
            xmlns="http://www.w3.org/2000/svg">
            <path
                d="M47.1,-57.8C59.9,-49.1,68.4,-33.3,71.8,-16.2C75.2,0.9,73.5,19.3,65.3,34.2C57.1,49.1,42.4,60.5,26.2,65.4C10,70.3,-7.7,68.7,-24.3,63.4C-40.9,58.1,-56.4,49.1,-65.7,35.5C-75,21.9,-78.1,3.7,-74.8,-12.9C-71.5,-29.5,-61.8,-44.5,-48.5,-53.1C-35.2,-61.7,-17.6,-63.9,-0.3,-63.5C17,-63.1,34.3,-66.5,47.1,-57.8Z"
                transform="translate(100 100)" />
        </svg>
        <svg class="pricing-creative-blob pricing-creative-blob-2" viewBox="0 0 200 200"
            xmlns="http://www.w3.org/2000/svg">
            <path
                d="M41.3,-54.7C51.6,-44.3,56.5,-28.9,60.4,-12.4C64.3,4.1,67.2,21.6,61.1,35.4C55,49.2,39.9,59.3,23.8,64.8C7.7,70.3,-9.4,71.2,-25.3,66.8C-41.2,62.4,-55.9,52.7,-64.3,38.8C-72.7,24.9,-74.8,6.8,-71.3,-10.1C-67.8,-27,-58.7,-42.7,-45.9,-52.8C-33.1,-62.9,-16.6,-67.4,-0.4,-66.9C15.8,-66.4,31.1,-65.1,41.3,-54.7Z"
                transform="translate(100 100)" />
        </svg>
        <div class="pricing-creative-circle pricing-creative-circle-1"></div>
        <div class="pricing-creative-circle pricing-creative-circle-2"></div>
    </div>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        <div class="text-center mb-12">
            <span class="pricing-creative-badge">{{ $section['badge'] }}</span>
            <h2 class="pricing-creative-title">{{ $section['title'] }}</h2>
            <p class="pricing-creative-subtitle">{{ $section['subtitle'] }}</p>
        </div>
        <div class="pricing-creative-grid">
            @foreach ($items as $index => $plan)
                <div class="pricing-creative-card {{ $plan['popular'] ? 'pricing-creative-card-popular' : '' }}"
                    style="--card-index: {{ $index }}">
                    <div class="pricing-creative-shape-bg"></div>
                    @if ($plan['popular'])
                        <div class="pricing-creative-popular-star">
                            <x-icon icon="lucide:star" class="w-5 h-5" />
                        </div>
                    @endif
                    <div class="pricing-creative-card-inner">
                        <div class="pricing-creative-header">
                            <div class="pricing-creative-icon-shape">
                                <div class="pricing-creative-icon-wrapper">
                                    <x-icon
                                        icon="{{ $index === 0 ? 'lucide:zap' : ($index === 1 ? 'lucide:rocket' : 'lucide:crown') }}"
                                        class="w-7 h-7" />
                                </div>
                            </div>
                            <h3 class="pricing-creative-name">{{ $plan['name'] }}</h3>
                            <p class="pricing-creative-desc">{{ $plan['description'] }}</p>
                        </div>
                        <div class="pricing-creative-price-section">
                            <div class="pricing-creative-price-line">
                                <span class="pricing-creative-currency">{{ $section['currency_symbol'] }}</span>
                                <span class="pricing-creative-price">{{ $plan['price'] }}</span>
                            </div>
                            <span class="pricing-creative-period">{{ $plan['period'] }}</span>
                        </div>
                        <div class="pricing-creative-wave-divider">
                            <svg viewBox="0 0 200 20" preserveAspectRatio="none">
                                <path d="M0,10 Q50,0 100,10 T200,10 L200,20 L0,20 Z" />
                            </svg>
                        </div>
                        <ul class="pricing-creative-features">
                            @foreach ($plan['features'] as $feature)
                                <li
                                    class="pricing-creative-feature {{ $feature['is_included'] ? '' : 'pricing-creative-feature-not-included' }}">
                                    <div class="pricing-creative-feature-icon-wrapper">
                                        <x-icon icon="{{ $feature['icon'] ?? 'lucide:check' }}" class="pricing-creative-feature-icon" />
                                    </div>
                                    <span>{{ $feature['text'] }}</span>
                                </li>
                            @endforeach
                        </ul>
                        <a href="{{ $section['cta_button_url'] ?? '#contact' }}" class="pricing-creative-btn">
                            <span>{{ $section['cta_button'] }}</span>
                            <x-icon icon="lucide:arrow-right" class="pricing-creative-arrow" />
                        </a>
                    </div>
                    <div class="pricing-creative-corner-shapes">
                        <div class="pricing-creative-corner pricing-creative-corner-tl"></div>
                        <div class="pricing-creative-corner pricing-creative-corner-br"></div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>

</div>