<?php
use Livewire\Component;
?>

<div>
<section id="services" class="services-cards-section {{ $isWhiteBackground ? 'services-cards-white' : 'services-cards-gray' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    {{-- Background Pattern --}}
    <div class="services-cards-bg">
        <div class="services-cards-pattern"></div>
        <div class="services-cards-shape services-cards-shape-1"></div>
        <div class="services-cards-shape services-cards-shape-2"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        {{-- Section Header --}}
        <div class="services-cards-header">
            <div class="services-cards-badge">
                <x-icon icon="lucide:sparkles" class="w-4 h-4" />
                <span>{{ $section['badge'] }}</span>
            </div>
            <h2 class="services-cards-title">{{ $section['title'] }}</h2>
            <p class="services-cards-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Services Grid --}}
        <div class="services-cards-grid">
            @foreach ($items as $index => $item)
                <div class="services-card-item scroll-animate" style="animation-delay: {{ $index * 100 }}ms">
                    {{-- Card Top Accent --}}
                    <div class="services-card-accent"></div>

                    {{-- Card Header --}}
                    <div class="services-card-header">
                        <div class="services-card-icon">
                            <x-icon icon="{{ $item['icon'] ?? 'heroicons:sparkles' }}" class="w-7 h-7" />
                        </div>
                        @if (!empty($item['price']))
                            <div class="services-card-price">{{ $item['price'] }}</div>
                        @endif
                    </div>

                    {{-- Card Body --}}
                    <div class="services-card-body">
                        <h3 class="services-card-title">{{ $item['title'] ?? '' }}</h3>
                        <p class="services-card-desc">{{ $item['description'] ?? '' }}</p>

                        {{-- Features --}}
                        @if (!empty($item['features']))
                            <div class="services-card-features">
                                @foreach ($item['features'] as $feature)
                                    <div class="services-card-feature">
                                        <x-icon icon="lucide:check-circle" class="w-4 h-4" />
                                        <span>{{ is_array($feature) ? ($feature['text'] ?? '') : $feature }}</span>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>

                    {{-- Card Footer --}}
                    @if (!empty($item['button_text']) && !empty($item['button_url']))
                        <div class="services-card-footer">
                            <a href="{{ $item['button_url'] }}" class="services-card-button">
                                <span>{{ $item['button_text'] }}</span>
                                <x-icon icon="{{ $item['button_icon'] ?? 'lucide:arrow-right' }}" class="w-4 h-4" />
                            </a>
                        </div>
                    @endif
                </div>
            @endforeach
        </div>
    </div>
</section>


</div>