<?php
use Livewire\Component;
?>

<div>
<section id="services" class="services-orbit-section {{ $isWhiteBackground ? 'services-orbit-white' : 'services-orbit-gray' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    {{-- Background Elements --}}
    <div class="services-orbit-bg">
        <div class="services-orbit-circle services-orbit-circle-1"></div>
        <div class="services-orbit-circle services-orbit-circle-2"></div>
        <div class="services-orbit-circle services-orbit-circle-3"></div>
        <div class="services-orbit-particles">
            @for ($i = 0; $i < 20; $i++)
                <div class="services-orbit-particle" style="--delay: {{ $i * 0.5 }}s; --x: {{ rand(0, 100) }}%; --y: {{ rand(0, 100) }}%;"></div>
            @endfor
        </div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        {{-- Section Header --}}
        <div class="services-orbit-header">
            <div class="services-orbit-badge">
                <div class="services-orbit-badge-orbit">
                    <span></span>
                </div>
                {{ $section['badge'] }}
            </div>
            <h2 class="services-orbit-title">{{ $section['title'] }}</h2>
            <p class="services-orbit-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Central Hub + Orbiting Cards --}}
        <div class="services-orbit-container">
            {{-- Central Hub --}}
            <div class="services-orbit-hub">
                <div class="services-orbit-hub-inner">
                    <div class="services-orbit-hub-icon">
                        <x-icon icon="lucide:sparkles" class="w-10 h-10" />
                    </div>
                    <div class="services-orbit-hub-text">
                        <span class="services-orbit-hub-count">{{ count($items) }}</span>
                        <span class="services-orbit-hub-label">Services</span>
                    </div>
                </div>
                <div class="services-orbit-hub-ring services-orbit-hub-ring-1"></div>
                <div class="services-orbit-hub-ring services-orbit-hub-ring-2"></div>
            </div>

            {{-- Service Cards --}}
            <div class="services-orbit-cards">
                @foreach ($items as $index => $item)
                    <div class="services-orbit-card scroll-animate" style="animation-delay: {{ $index * 100 }}ms">
                        <div class="services-orbit-card-connector"></div>
                        <div class="services-orbit-card-inner">
                            {{-- Card Header --}}
                            <div class="services-orbit-card-header">
                                <div class="services-orbit-icon">
                                    <x-icon icon="{{ $item['icon'] ?? 'heroicons:sparkles' }}" class="w-6 h-6" />
                                </div>
                                <div class="services-orbit-number">{{ str_pad($index + 1, 2, '0', STR_PAD_LEFT) }}</div>
                            </div>

                            {{-- Content --}}
                            <div class="services-orbit-content">
                                <h3 class="services-orbit-card-title">{{ $item['title'] ?? '' }}</h3>
                                <p class="services-orbit-desc">{{ $item['description'] ?? '' }}</p>

                                @if (!empty($item['price']))
                                    <div class="services-orbit-price">
                                        <x-icon icon="lucide:tag" class="w-4 h-4" />
                                        {{ $item['price'] }}
                                    </div>
                                @endif

                                {{-- Features --}}
                                @if (!empty($item['features']))
                                    <div class="services-orbit-features">
                                        @foreach (array_slice($item['features'], 0, 2) as $feature)
                                            <span class="services-orbit-feature">
                                                <x-icon icon="lucide:check" class="w-3.5 h-3.5" />
                                                {{ is_array($feature) ? ($feature['text'] ?? '') : $feature }}
                                            </span>
                                        @endforeach
                                    </div>
                                @endif
                            </div>

                            {{-- Button --}}
                            @if (!empty($item['button_text']) && !empty($item['button_url']))
                                <a href="{{ $item['button_url'] }}" class="services-orbit-btn">
                                    {{ $item['button_text'] }}
                                    <x-icon icon="{{ $item['button_icon'] ?? 'lucide:arrow-right' }}" class="w-4 h-4" />
                                </a>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</section>


</div>