<?php
use Livewire\Component;
?>

<div>
    

    <section class="section relative promo-minimal-bg"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Minimal Geometric Shapes --}}
        <div class="promo-minimal-shapes">
            <div class="promo-minimal-line promo-minimal-line-1"></div>
            <div class="promo-minimal-line promo-minimal-line-2"></div>
            <div class="promo-minimal-line promo-minimal-line-3"></div>
            <div class="promo-minimal-dot promo-minimal-dot-1"></div>
            <div class="promo-minimal-dot promo-minimal-dot-2"></div>
            <div class="promo-minimal-dot promo-minimal-dot-3"></div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20">
            <div class="promo-minimal-content">
                {{-- Badge --}}
                <div class="promo-minimal-badge">
                    <x-icon icon="{{ $section['icon'] }}" class="w-4 h-4" />
                    <span>{{ $section['subtitle'] }}</span>
                </div>

                {{-- Headline --}}
                <h2 class="promo-minimal-headline">{{ $section['headline'] }}</h2>

                {{-- Description --}}
                <p class="promo-minimal-description">{{ $section['description'] }}</p>

                {{-- Countdown Timer --}}
                @if ($section['show_countdown'] && !empty($section['expiry_date']))
                    <div class="promo-minimal-countdown" data-countdown-timer
                        data-expiry="{{ $section['expiry_date'] }}">
                        <div class="promo-minimal-countdown-item">
                            <div class="promo-minimal-countdown-value" data-countdown-days>00</div>
                            <div class="promo-minimal-countdown-label">{{ $section['countdown_days_label'] ?? 'Days' }}
                            </div>
                        </div>
                        <div class="promo-minimal-countdown-item">
                            <div class="promo-minimal-countdown-value" data-countdown-hours>00</div>
                            <div class="promo-minimal-countdown-label">{{ $section['countdown_hours_label'] ?? 'Hrs' }}
                            </div>
                        </div>
                        <div class="promo-minimal-countdown-item">
                            <div class="promo-minimal-countdown-value" data-countdown-minutes>00</div>
                            <div class="promo-minimal-countdown-label">
                                {{ $section['countdown_minutes_label'] ?? 'Mins' }}</div>
                        </div>
                        <div class="promo-minimal-countdown-item">
                            <div class="promo-minimal-countdown-value" data-countdown-seconds>00</div>
                            <div class="promo-minimal-countdown-label">
                                {{ $section['countdown_seconds_label'] ?? 'Secs' }}</div>
                        </div>
                    </div>
                @endif

                {{-- Promo Code --}}
                @if ($section['show_promo_code'] && !empty($section['promo_code']))
                    <div class="promo-minimal-code-wrapper" x-data="{ copied: false }"
                        @click="navigator.clipboard.writeText('{{ $section['promo_code'] }}'); copied = true; setTimeout(() => copied = false, 2000)">
                        <span class="promo-minimal-code-text">{{ $section['promo_code'] }}</span>
                        <x-icon icon="lucide:copy" class="w-5 h-5 text-primary-500" x-show="!copied" />
                        <x-icon icon="lucide:check" class="w-5 h-5 text-green-500" x-show="copied" x-cloak />
                    </div>
                @endif

                {{-- CTA Button --}}
                <a href="{{ $section['cta_url'] }}" class="promo-minimal-cta">
                    <span>{{ $section['cta_text'] }}</span>
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M13 7l5 5m0 0l-5 5m5-5H6" />
                    </svg>
                </a>

                {{-- Terms --}}
                @if (!empty($section['terms']))
                    <p class="promo-minimal-terms">{{ $section['terms'] }}</p>
                @endif
            </div>
        </div>
    </section>

    @if (($section['show_countdown'] ?? false) && !empty($section['expiry_date']))
        @script
            <script>
                (function() {
                    const timers = document.querySelectorAll('[data-countdown-timer]');

                    timers.forEach(function(wrapper) {
                        if (wrapper.dataset.countdownInitialized) return;
                        wrapper.dataset.countdownInitialized = 'true';

                        const endDateStr = (wrapper.getAttribute('data-expiry') || '').replace(' ', 'T');
                        if (!endDateStr) return;

                        const daysEl = wrapper.querySelector('[data-countdown-days]');
                        const hoursEl = wrapper.querySelector('[data-countdown-hours]');
                        const minutesEl = wrapper.querySelector('[data-countdown-minutes]');
                        const secondsEl = wrapper.querySelector('[data-countdown-seconds]');

                        if (!daysEl || !hoursEl || !minutesEl || !secondsEl) return;

                        function updateCountdown() {
                            const end = new Date(endDateStr).getTime();
                            const now = new Date().getTime();
                            const diff = end - now;

                            if (diff > 0) {
                                daysEl.textContent = String(Math.floor(diff / (1000 * 60 * 60 * 24))).padStart(2, '0');
                                hoursEl.textContent = String(Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 *
                                    60))).padStart(2, '0');
                                minutesEl.textContent = String(Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60)))
                                    .padStart(2, '0');
                                secondsEl.textContent = String(Math.floor((diff % (1000 * 60)) / 1000)).padStart(2,
                                '0');
                            } else {
                                wrapper.style.display = 'none';
                            }
                        }

                        updateCountdown();
                        setInterval(updateCountdown, 1000);
                    });
                })();
            </script>
        @endscript
    @endif

</div>