<?php
use Livewire\Component;
?>

<div>
    <section class="hero4-section" @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Background Blobs --}}
        <div class="hero4-blob hero4-blob-1"></div>
        <div class="hero4-blob hero4-blob-2"></div>
        <div class="hero4-blob hero4-blob-3"></div>

        {{-- Container --}}
        <div class="hero4-container">
            {{-- Main Content --}}
            <div class="hero4-content">
                {{-- Badge --}}
                <div class="hero4-badge animate-fade-in-down">
                    <div class="hero4-badge-icon">
                        <svg class="w-4 h-4 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd"
                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <span class="hero4-badge-text">{{ $hero['badge'] }}</span>
                </div>

                {{-- Title --}}
                <h1 class="hero4-title animate-fade-in-up">
                    {{ $hero['title'] }}
                    <span class="hero4-title-gradient">{{ $hero['subtitle'] }}</span>
                </h1>

                {{-- Description --}}
                <p class="hero4-description animate-fade-in-up delay-200">{{ $hero['description'] }}</p>

                {{-- CTA Buttons --}}
                <div class="hero4-cta-group animate-fade-in-up delay-300">
                    @foreach ($hero['buttons'] ?? [] as $index => $button)
                        @if ($button['is_transparent'] ?? false)
                            <a href="{{ $button['url'] ?? '#' }}" class="hero4-btn-secondary">
                                @if (!empty($button['icon']))
                                    <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                @endif
                                @if (!empty($button['text']))
                                    <span>{{ $button['text'] }}</span>
                                @endif
                            </a>
                        @else
                            <a href="{{ $button['url'] ?? '#' }}" class="hero4-btn-primary">
                                @if (!empty($button['icon']))
                                    <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                @endif
                                @if (!empty($button['text']))
                                    <span>{{ $button['text'] }}</span>
                                @endif
                            </a>
                        @endif
                    @endforeach
                </div>

                {{-- Image with Float Cards --}}
                <div class="hero4-image-container animate-fade-in-up delay-400">
                    <div class="hero4-image-wrapper">
                        <img src="{{ $hero['hero_image_url'] ?? ($hero['hero_image'] ?? 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600&h=500&fit=crop') }}"
                            alt="Professional Laundry Service" loading="lazy">
                    </div>

                    {{-- Floating Cards --}}
                    @foreach ($hero['floating_cards'] ?? [] as $index => $card)
                        <div
                            class="hero4-float-card hero4-float-card-{{ $index + 1 }} animate-bounce-soft {{ $index > 0 ? 'delay-300' : '' }}">
                            <div class="hero4-float-icon {{ $index === 0 ? 'green' : 'purple' }}">
                                <x-icon icon="{{ $card['icon'] ?? 'heroicons:check' }}" class="w-5 h-5 text-white" />
                            </div>
                            <div>
                                <p class="hero4-float-title">{{ $card['title'] ?? '' }}</p>
                                <p class="hero4-float-subtitle">{{ $card['subtitle'] ?? '' }}</p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        {{-- Stats Bar --}}
        @if (!empty($hero['stats']))
            <div class="hero4-stats-bar">
                <div class="hero4-stats">
                    @foreach ($hero['stats'] as $stat)
                        <div class="hero4-stat-item">
                            @if (!empty($stat['icon']))
                                <div class="hero4-stat-icon">
                                    <x-icon icon="{{ $stat['icon'] }}" class="w-5 h-5" />
                                </div>
                            @endif
                            <div>
                                <div class="hero4-stat-value">{{ $stat['value'] }}</div>
                                <div class="hero4-stat-label">{{ $stat['label'] }}</div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif
    </section>

    
</div>