<?php
use Livewire\Component;
?>

<div>
    

    <section id="app-download"
        class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid lg:grid-cols-2 gap-12 items-center">
                {{-- Content Column --}}
                <div class="scroll-animate" data-animation="fade-right">
                    <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>

                    <h2 class="section-title text-left">{{ $section['title'] }}</h2>

                    @if (!empty($section['subtitle']))
                        <p class="text-lg text-primary-600 dark:text-primary-400 font-medium mb-4">
                            {{ $section['subtitle'] }}
                        </p>
                    @endif

                    @if (!empty($section['description']))
                        <div class="prose prose-lg dark:prose-invert max-w-none text-gray-600 dark:text-gray-300 mb-8">
                            {!! $section['description'] !!}
                        </div>
                    @endif

                    {{-- App Features --}}
                    @if (count($items) > 0)
                        <div class="space-y-4 mb-8">
                            @foreach ($items as $feature)
                                <div class="flex items-start gap-4">
                                    <div class="app-feature-icon">
                                        <x-icon icon="{{ $feature['icon'] ?? 'heroicons:check' }}"
                                            class="w-5 h-5 text-white" />
                                    </div>
                                    <div>
                                        <h4 class="font-semibold text-gray-900 dark:text-white">
                                            {{ $feature['title'] ?? '' }}</h4>
                                        @if (!empty($feature['description']))
                                            <p class="text-gray-600 dark:text-gray-400 text-sm">
                                                {{ $feature['description'] }}</p>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    {{-- Download Buttons --}}
                    @php
                        $ctaButtons = $section['cta_buttons'] ?? [];
                        // Fallback for backwards compatibility with old format
                        if (
                            empty($ctaButtons) &&
                            (!empty($section['app_store_url']) || !empty($section['play_store_url']))
                        ) {
                            $ctaButtons = [];
                            if (!empty($section['app_store_url'])) {
                                $ctaButtons[] = [
                                    'icon' => 'mdi:apple',
                                    'url' => $section['app_store_url'],
                                    'text_top' => $section['app_store_text_top'] ?? 'Download on the',
                                    'text_main' => $section['app_store_text_main'] ?? 'App Store',
                                ];
                            }
                            if (!empty($section['play_store_url'])) {
                                $ctaButtons[] = [
                                    'icon' => 'mdi:google-play',
                                    'url' => $section['play_store_url'],
                                    'text_top' => $section['play_store_text_top'] ?? 'Get it on',
                                    'text_main' => $section['play_store_text_main'] ?? 'Google Play',
                                ];
                            }
                        }
                    @endphp
                    @if (count($ctaButtons) > 0)
                        <div class="flex flex-wrap gap-4">
                            @foreach ($ctaButtons as $index => $button)
                                @if (!empty($button['url']))
                                    <a href="{{ $button['url'] }}" target="_blank" rel="noopener"
                                        class="store-button {{ $index === 0 ? 'store-button-primary' : 'store-button-secondary' }} inline-flex items-center gap-3 px-6 py-3 rounded-xl shadow-lg">
                                        <x-icon icon="{{ $button['icon'] ?? 'heroicons:device-phone-mobile' }}"
                                            class="w-8 h-8" />
                                        <div class="text-left">
                                            <div class="text-xs opacity-80">{{ $button['text_top'] ?? '' }}</div>
                                            <div class="text-lg font-semibold -mt-1">{{ $button['text_main'] ?? '' }}
                                            </div>
                                        </div>
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    @endif

                    {{-- App Stats & Social Proof --}}
                    @php
                        $appStats = $section['app_stats'] ?? [];
                    @endphp
                    <div class="mt-8 space-y-6">
                        {{-- Stats Grid --}}
                        @if (count($appStats) > 0)
                            <div class="grid grid-cols-{{ count($appStats) }} gap-4">
                                @foreach ($appStats as $stat)
                                    <div class="text-center">
                                        <div class="flex items-center justify-center gap-1">
                                            @if (!empty($stat['icon']))
                                                <x-icon icon="{{ $stat['icon'] }}" class="w-5 h-5 text-primary-500" />
                                            @endif
                                            <span
                                                class="text-2xl font-bold text-gray-900 dark:text-white">{{ $stat['value'] ?? '' }}</span>
                                        </div>
                                        <div class="text-xs text-gray-600 dark:text-gray-400 mt-1">
                                            {{ $stat['label'] ?? '' }}
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        {{-- Trusted Users with Avatars --}}
                        @php
                            // Get trusted_users config (new nested format or fallback to old format)
                            $trustedUsers = $section['trusted_users'] ?? [];
                            $trustedUsersEnabled = $trustedUsers['enabled'] ?? true;

                            // Get avatars from nested format or fallback to old user_avatars format
                            $userAvatars = $trustedUsers['avatars'] ?? ($section['user_avatars'] ?? []);
                            // Default avatars if none provided (using repeater format with image and name)
                            if (empty($userAvatars)) {
                                $userAvatars = [
                                    ['image' => 'https://i.pravatar.cc/100?img=1', 'name' => 'User 1'],
                                    ['image' => 'https://i.pravatar.cc/100?img=2', 'name' => 'User 2'],
                                    ['image' => 'https://i.pravatar.cc/100?img=3', 'name' => 'User 3'],
                                    ['image' => 'https://i.pravatar.cc/100?img=4', 'name' => 'User 4'],
                                    ['image' => 'https://i.pravatar.cc/100?img=5', 'name' => 'User 5'],
                                ];
                            }
                            // Get trusted users count from app_stats (last item) or fallback
                            $trustedUsersCount = '100K+';
                            if (!empty($appStats)) {
                                // Find the users stat (typically last one) or use the last stat's value
    $lastStat = end($appStats);
    $trustedUsersCount = $lastStat['value'] ?? $trustedUsersCount;
}
// Get trusted users title and replace %count% placeholder (new nested format or old format)
$trustedTitle =
    $trustedUsers['title'] ??
    ($section['trusted_users_title'] ?? 'Trusted by %count% users');
$trustedTitle = str_replace('%count%', $trustedUsersCount, $trustedTitle);
// Get subtitle from nested format or old format
$trustedSubtitle =
    $trustedUsers['subtitle'] ??
    ($section['trusted_users_subtitle'] ?? 'Join thousands of satisfied customers');
                        @endphp
                        @if ($trustedUsersEnabled)
                            <div class="flex items-center gap-3">
                                {{-- Avatar Stack --}}
                                <div class="flex -space-x-2">
                                    @foreach (array_slice($userAvatars, 0, 5) as $index => $avatar)
                                        @php
                                            // Handle both repeater format (array with image/image_url) and simple URL string
                                            $avatarUrl = is_array($avatar)
                                                ? $avatar['image_url'] ?? ($avatar['image'] ?? null)
                                                : $avatar;
                                            $avatarName = is_array($avatar) ? $avatar['name'] ?? 'User' : 'User';
                                        @endphp
                                        @if ($avatarUrl)
                                            <img src="{{ $avatarUrl }}" alt="{{ $avatarName }}"
                                                title="{{ $avatarName }}"
                                                class="w-10 h-10 rounded-full border-2 border-white dark:border-gray-800 object-cover"
                                                loading="lazy">
                                        @endif
                                    @endforeach
                                </div>

                                {{-- Trusted Text --}}
                                <div class="flex-1">
                                    <p class="text-sm font-medium text-gray-900 dark:text-white">
                                        {{ $trustedTitle }}
                                    </p>
                                    <p class="text-xs text-gray-600 dark:text-gray-400">
                                        {{ $trustedSubtitle }}
                                    </p>
                                </div>
                            </div>
                        @endif

                        {{-- QR Code (Optional - Clean Design) --}}
                        @php
                            $qrCodeUrl = $section['qr_code_url'] ?? ($section['qr_code'] ?? null);
                        @endphp
                        @if ($qrCodeUrl)
                            <div class="flex items-center gap-4 pt-4 border-t border-gray-200 dark:border-gray-700">
                                {{-- QR Code Image --}}
                                <div class="qr-code-simple flex-shrink-0">
                                    <img src="{{ $qrCodeUrl }}" alt="QR Code" class="w-20 h-20 object-contain"
                                        loading="lazy">
                                </div>

                                {{-- QR Code Text --}}
                                <div>
                                    <p class="text-sm font-medium text-gray-900 dark:text-white">
                                        {{ $section['qr_label'] ?? 'Scan to Download' }}
                                    </p>
                                    <p class="text-xs text-gray-600 dark:text-gray-400">
                                        {{ $section['qr_description'] ?? 'Quick access with your camera' }}
                                    </p>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>

                {{-- App Image Column --}}
                <div class="scroll-animate flex justify-center" data-animation="fade-left">
                    @php
                        $appImageUrl = $section['app_image_url'] ?? ($section['app_image'] ?? null);
                    @endphp
                    @if ($appImageUrl)
                        <div class="app-mockup">
                            <img src="{{ $appImageUrl }}" alt="{{ $section['title'] }}"
                                class="max-w-sm w-full h-auto drop-shadow-2xl rounded-3xl" loading="lazy">
                        </div>
                    @else
                        <div
                            class="app-mockup bg-gradient-to-br from-primary-500 to-primary-700 rounded-3xl p-4 max-w-xs w-full">
                            <div
                                class="bg-white dark:bg-gray-800 rounded-2xl aspect-[9/19] flex items-center justify-center">
                                <x-icon icon="heroicons:device-phone-mobile"
                                    class="w-20 h-20 text-gray-300 dark:text-gray-600" />
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </section>
</div>