<?php
use Livewire\Component;
?>

<div>
    


    <section id="team"
        class="team-wave-section section {{ $isWhiteBackground ? 'team-wave-white bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Wave Background --}}
        <div class="team-wave-bg">
            <svg class="team-wave-svg" viewBox="0 0 1440 150" preserveAspectRatio="none">
                <path d="M0,64 C288,120 576,0 864,64 C1152,128 1440,32 1440,32 L1440,150 L0,150 Z"></path>
            </svg>
            {{-- Floating Shapes --}}
            <div class="team-wave-floating-shape team-wave-floating-shape-1"></div>
            <div class="team-wave-floating-shape team-wave-floating-shape-2"></div>
            {{-- Particles --}}
            <div class="team-wave-particles">
                @for ($i = 0; $i < 10; $i++)
                    <div class="team-wave-particle"
                        style="left: {{ rand(5, 95) }}%; bottom: {{ rand(5, 30) }}%; animation-delay: {{ $i * 1.5 }}s; animation-duration: {{ rand(12, 20) }}s;">
                    </div>
                @endfor
            </div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Section Header --}}
            <div class="team-wave-header text-center mb-16 scroll-animate" data-animation="fade-up">
                @if (!empty($section['badge']))
                    <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                @endif

                <h2 class="section-title">
                    <span class="team-wave-title-underline">{{ $section['title'] }}</span>
                </h2>

                @if (!empty($section['subtitle']))
                    <p class="section-subtitle">{{ $section['subtitle'] }}</p>
                @endif
            </div>

            {{-- Team Grid --}}
            <div class="team-wave-grid grid sm:grid-cols-2 lg:grid-cols-4 gap-8">
                @foreach ($items as $index => $member)
                    <div class="team-wave-card scroll-animate" data-animation="fade-up"
                        style="animation-delay: {{ $index * 100 }}ms">
                        {{-- Card Wave --}}
                        <div class="team-wave-card-wave">
                            <svg viewBox="0 0 500 50" preserveAspectRatio="none">
                                <path d="M0,25 C125,50 250,0 375,25 C437.5,37.5 468.75,31.25 500,25 L500,50 L0,50 Z">
                                </path>
                            </svg>
                        </div>

                        {{-- Image --}}
                        <div class="team-wave-image-wrapper">
                            @php
                                $imageUrl = $member['image_url'] ?? ($member['image'] ?? null);
                                $defaultPlaceholder =
                                    'https://ui-avatars.com/api/?name=' .
                                    urlencode($member['name'] ?? 'Team') .
                                    '&size=300&background=random&color=fff&bold=true';
                            @endphp
                            <img src="{{ $imageUrl ?: $defaultPlaceholder }}" alt="{{ $member['name'] ?? '' }}"
                                class="team-wave-image" loading="lazy">
                        </div>

                        {{-- Content --}}
                        <div class="team-wave-content">
                            <h3 class="team-wave-name">{{ $member['name'] ?? '' }}</h3>

                            @if (!empty($member['position']) || !empty($member['role']))
                                <p class="team-wave-position">{{ $member['position'] ?? $member['role'] }}</p>
                            @endif

                            @if (!empty($member['bio']))
                                <p class="team-wave-bio line-clamp-2">{{ $member['bio'] }}</p>
                            @endif

                            @if (!empty($member['social_links']))
                                <div class="team-wave-social">
                                    @foreach ($member['social_links'] as $social)
                                        <a href="{{ $social['url'] ?? '#' }}" target="_blank" rel="noopener">
                                            <x-icon icon="{{ $social['icon'] ?? 'mdi:link' }}" class="w-4 h-4" />
                                        </a>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
</div>