<?php
use Livewire\Component;
?>

<div>
<section class="features-split-section {{ $isWhiteBackground ? 'features-split-white' : 'features-split-gray' }}" @if($this->getPaddingStyle()) style="{{ $this->getPaddingStyle() }}" @endif>
    {{-- Background Gradient --}}
    <div class="features-split-bg">
        <div class="features-split-gradient-orb features-split-gradient-orb-1"></div>
        <div class="features-split-gradient-orb features-split-gradient-orb-2"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        <div class="features-split-container">
            @foreach ($items as $index => $feature)
                @php
                    $isEven = $index % 2 === 0;
                @endphp
                <div class="features-split-row {{ $isEven ? 'features-split-row-normal' : 'features-split-row-reverse' }} scroll-animate" style="animation-delay: {{ $index * 100 }}ms">
                    {{-- Icon Side --}}
                    <div class="features-split-icon-side">
                        <div class="features-split-icon-wrapper">
                            {{-- Animated Ring --}}
                            <div class="features-split-ring"></div>

                            {{-- Icon Container --}}
                            <div class="features-split-icon-container">
                                <div class="features-split-icon-bg"></div>
                                <div class="features-split-icon">
                                    <x-icon icon="{{ $feature['icon'] ?? 'heroicons:heart' }}" class="w-10 h-10" />
                                </div>
                            </div>

                            {{-- Decorative Dots --}}
                            <div class="features-split-dots">
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                        </div>
                    </div>

                    {{-- Content Side --}}
                    <div class="features-split-content-side">
                        <div class="features-split-content">
                            {{-- Step Number --}}
                            <div class="features-split-step">{{ str_pad($index + 1, 2, '0', STR_PAD_LEFT) }}</div>

                            <h3 class="features-split-title">{{ $feature['title'] }}</h3>
                            <p class="features-split-desc">{{ $feature['description'] }}</p>

                            {{-- Progress Bar --}}
                            <div class="features-split-progress">
                                <div class="features-split-progress-bar"></div>
                            </div>
                        </div>
                    </div>

                    {{-- Connecting Line --}}
                    @if ($index < count($items) - 1)
                        <div class="features-split-connector"></div>
                    @endif
                </div>
            @endforeach
        </div>
    </div>
</section>


</div>