<?php
use Livewire\Component;
?>

<div>
<section id="services" class="services-floating-section {{ $isWhiteBackground ? 'services-floating-white' : 'services-floating-gray' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    {{-- Background Elements --}}
    <div class="services-floating-bg">
        <div class="services-floating-gradient"></div>
        <div class="services-floating-grid"></div>
        <div class="services-floating-glow services-floating-glow-1"></div>
        <div class="services-floating-glow services-floating-glow-2"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        {{-- Section Header --}}
        <div class="services-floating-header">
            <div class="services-floating-badge">
                <div class="services-floating-badge-glow"></div>
                <x-icon icon="lucide:sparkles" class="w-4 h-4" />
                <span>{{ $section['badge'] }}</span>
            </div>
            <h2 class="services-floating-title">{{ $section['title'] }}</h2>
            <p class="services-floating-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Services Grid --}}
        <div class="services-floating-grid-container">
            @foreach ($items as $index => $item)
                <div class="services-floating-card scroll-animate" style="animation-delay: {{ $index * 100 }}ms">
                    <div class="services-floating-card-shine"></div>
                    <div class="services-floating-card-inner">
                        {{-- Card Header --}}
                        <div class="services-floating-card-header">
                            <div class="services-floating-icon">
                                <div class="services-floating-icon-glow"></div>
                                <x-icon icon="{{ $item['icon'] ?? 'heroicons:sparkles' }}" class="w-7 h-7" />
                            </div>
                            @if (!empty($item['price']))
                                <div class="services-floating-price">{{ $item['price'] }}</div>
                            @endif
                        </div>

                        {{-- Card Content --}}
                        <div class="services-floating-content">
                            <h3 class="services-floating-card-title">{{ $item['title'] ?? '' }}</h3>
                            <p class="services-floating-desc">{{ $item['description'] ?? '' }}</p>
                        </div>

                        {{-- Features --}}
                        @if (!empty($item['features']))
                            <div class="services-floating-features">
                                @foreach ($item['features'] as $feature)
                                    <div class="services-floating-feature">
                                        <span class="services-floating-feature-icon">
                                            <x-icon icon="lucide:check" class="w-3.5 h-3.5" />
                                        </span>
                                        <span>{{ is_array($feature) ? ($feature['text'] ?? '') : $feature }}</span>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        {{-- Button --}}
                        @if (!empty($item['button_text']) && !empty($item['button_url']))
                            <a href="{{ $item['button_url'] }}" class="services-floating-btn">
                                <span>{{ $item['button_text'] }}</span>
                                <x-icon icon="{{ $item['button_icon'] ?? 'lucide:arrow-right' }}" class="w-4 h-4" />
                            </a>
                        @endif
                    </div>

                    {{-- Floating Elements --}}
                    <div class="services-floating-element services-floating-element-1"></div>
                    <div class="services-floating-element services-floating-element-2"></div>
                </div>
            @endforeach
        </div>
    </div>
</section>


</div>