<?php
use Livewire\Component;
?>

<div>
<section id="team" class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Header --}}
        <div class="text-center mb-16">
            <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
            <h2 class="section-title">{{ $section['title'] }}</h2>
            <p class="section-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Team Grid --}}
        <div class="grid sm:grid-cols-2 lg:grid-cols-4 gap-8">
            @foreach($items as $index => $member)
            <div class="team-card bg-white dark:bg-gray-800 rounded-2xl shadow-lg overflow-hidden scroll-animate" data-animation="fade-up" style="animation-delay: {{ $index * 100 }}ms">
                {{-- Member Image --}}
                <div class="team-image relative aspect-square">
                    @php
                        $imageUrl = $member['image_url'] ?? $member['image'] ?? null;
                        $defaultPlaceholder = 'https://ui-avatars.com/api/?name=' . urlencode($member['name'] ?? 'Team') . '&size=300&background=random&color=fff&bold=true';
                    @endphp
                    <img src="{{ $imageUrl ?: $defaultPlaceholder }}" alt="{{ $member['name'] ?? '' }}" class="w-full h-full object-cover" loading="lazy">

                    {{-- Social Links Overlay --}}
                    @if(!empty($member['social_links']))
                    <div class="team-social absolute bottom-0 left-0 right-0 p-4 bg-gradient-to-t from-black/80 to-transparent">
                        <div class="flex justify-center gap-3">
                            @foreach($member['social_links'] as $social)
                            <a href="{{ $social['url'] ?? '#' }}" target="_blank" rel="noopener" class="w-9 h-9 rounded-full bg-white/20 hover:bg-primary-500 flex items-center justify-center text-white transition-colors">
                                <x-icon icon="{{ $social['icon'] ?? 'mdi:link' }}" class="w-4 h-4" />
                            </a>
                            @endforeach
                        </div>
                    </div>
                    @endif
                </div>

                {{-- Member Info --}}
                <div class="p-6 text-center">
                    <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-1">
                        {{ $member['name'] ?? '' }}
                    </h3>
                    @if(!empty($member['position']) || !empty($member['role']))
                    <p class="text-primary-600 dark:text-primary-400 text-sm font-semibold mb-2">
                        {{ $member['position'] ?? $member['role'] }}
                    </p>
                    @endif
                    @if(!empty($member['bio']))
                    <p class="text-gray-600 dark:text-gray-400 text-sm line-clamp-2">
                        {{ $member['bio'] }}
                    </p>
                    @endif
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>


</div>