<?php
use Livewire\Component;
?>

<div>
    

    <section id="team"
        class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Section Header --}}
            <div class="text-center mb-16 scroll-animate" data-animation="fade-up">
                @if (!empty($section['badge']))
                    <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                @endif
                <h2 class="section-title">{{ $section['title'] }}</h2>
                @if (!empty($section['subtitle']))
                    <p class="section-subtitle">{{ $section['subtitle'] }}</p>
                @endif
            </div>

            {{-- Team Carousel --}}
            <div class="team-carousel-container px-12" x-data="{ currentSlide: 0, totalSlides: {{ count($items) }}, slidesPerView: 3 }" x-init="function updateSlidesPerView() {
                if (window.innerWidth < 640) slidesPerView = 1;
                else if (window.innerWidth < 1024) slidesPerView = 2;
                else slidesPerView = 3;
            }
            updateSlidesPerView();
            window.addEventListener('resize', updateSlidesPerView);">

                {{-- Navigation Buttons --}}
                <button class="team-carousel-nav prev" @click="currentSlide = Math.max(0, currentSlide - 1)"
                    :disabled="currentSlide === 0" :class="{ 'opacity-50 cursor-not-allowed': currentSlide === 0 }">
                    <svg class="w-6 h-6 rtl:rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                    </svg>
                </button>
                <button class="team-carousel-nav next"
                    @click="currentSlide = Math.min(totalSlides - slidesPerView, currentSlide + 1)"
                    :disabled="currentSlide >= totalSlides - slidesPerView"
                    :class="{ 'opacity-50 cursor-not-allowed': currentSlide >= totalSlides - slidesPerView }">
                    <svg class="w-6 h-6 rtl:rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </button>

                {{-- Carousel Track --}}
                <div class="overflow-hidden">
                    <div class="team-carousel-track"
                        :style="'transform: translateX(' + (currentSlide * -(100 / slidesPerView)) + '%)'">
                        @foreach ($items as $index => $member)
                            <div class="team-carousel-card scroll-animate" data-animation="fade-up"
                                style="animation-delay: {{ $index * 100 }}ms">
                                <div class="card-inner text-center text-white">
                                    @php
                                        $imageUrl = $member['image_url'] ?? ($member['image'] ?? null);
                                        $defaultPlaceholder =
                                            'https://ui-avatars.com/api/?name=' .
                                            urlencode($member['name'] ?? 'Team') .
                                            '&size=300&background=random&color=fff&bold=true';
                                    @endphp
                                    <img src="{{ $imageUrl ?: $defaultPlaceholder }}" alt="{{ $member['name'] ?? '' }}"
                                        class="team-carousel-image" loading="lazy">

                                    <h3 class="text-xl font-bold mb-1">{{ $member['name'] ?? '' }}</h3>

                                    @if (!empty($member['position']) || !empty($member['role']))
                                        <p class="text-white/80 text-sm font-medium mb-3">
                                            {{ $member['position'] ?? $member['role'] }}
                                        </p>
                                    @endif

                                    @if (!empty($member['bio']))
                                        <p class="text-white/70 text-sm mb-4 line-clamp-2">{{ $member['bio'] }}</p>
                                    @endif

                                    @if (!empty($member['social_links']))
                                        <div class="team-carousel-social flex justify-center gap-2">
                                            @foreach ($member['social_links'] as $social)
                                                <a href="{{ $social['url'] ?? '#' }}" target="_blank" rel="noopener">
                                                    <x-icon icon="{{ $social['icon'] ?? 'mdi:link' }}"
                                                        class="w-4 h-4" />
                                                </a>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                {{-- Dots Navigation --}}
                <div class="flex justify-center gap-2 mt-8">
                    @foreach ($items as $index => $member)
                        @if ($index <= count($items) - 3)
                            <button class="w-3 h-3 rounded-full transition-all duration-300"
                                :class="currentSlide === {{ $index }} ? 'bg-primary-600 w-8' :
                                    'bg-gray-300 dark:bg-gray-600 hover:bg-gray-400'"
                                @click="currentSlide = {{ $index }}">
                            </button>
                        @endif
                    @endforeach
                </div>
            </div>
        </div>
    </section>
</div>