<?php
use Livewire\Component;
?>

<section
    class="pricing-comparison-section {{ $isWhiteBackground ? 'pricing-comparison-white' : 'pricing-comparison-gray' }}"
    @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="pricing-comparison-bg"></div>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        <div class="text-center mb-12">
            <span class="pricing-comparison-badge">{{ $section['badge'] }}</span>
            <h2 class="pricing-comparison-title">{{ $section['title'] }}</h2>
            <p class="pricing-comparison-subtitle">{{ $section['subtitle'] }}</p>
        </div>
        <div class="pricing-comparison-table-container">
            <table class="pricing-comparison-table">
                <thead>
                    <tr>
                        <th class="pricing-comparison-th-feature">Features</th>
                        @foreach ($items as $plan)
                            <th
                                class="pricing-comparison-th-plan {{ $plan['popular'] ? 'pricing-comparison-popular' : '' }}">
                                @if ($plan['popular'])
                                    <div class="pricing-comparison-popular-tag">{{ $section['popular_badge'] }}</div>
                                @endif
                                <div class="pricing-comparison-plan-name">{{ $plan['name'] }}</div>
                                <div class="pricing-comparison-price">
                                    {{ $section['currency_symbol'] }}{{ $plan['price'] }}</div>
                                <div class="pricing-comparison-period">/{{ $plan['period'] }}</div>
                                <a href="{{ $section['cta_button_url'] ?? '#contact' }}"
                                    class="pricing-comparison-btn">{{ $section['cta_button'] }}</a>
                            </th>
                        @endforeach
                    </tr>
                </thead>
                <tbody>
                    @php
                        $allFeatures = [];
                        foreach ($items as $p) {
                            foreach ($p['features'] ?? [] as $f) {
                                $allFeatures[$f['text']] = true;
                            }
                        }
                    @endphp
                    @foreach (array_keys($allFeatures) as $featureText)
                        <tr class="pricing-comparison-row">
                            <td class="pricing-comparison-feature-name">{{ $featureText }}</td>
                            @php $featureIncludedInPreviousPlan = false; @endphp
                            @foreach ($items as $planIndex => $plan)
                                @php
                                    $feature = collect($plan['features'] ?? [])->firstWhere('text', $featureText);
                                    $isExplicitlyIncluded = $feature ? $feature['is_included'] ?? false : false;
                                    // If feature was included in previous plan, it's included in current plan too
                                    $isIncluded = $isExplicitlyIncluded || $featureIncludedInPreviousPlan;
                                    // Update for next iteration
                                    if ($isIncluded) {
                                        $featureIncludedInPreviousPlan = true;
                                    }
                                @endphp
                                <td class="pricing-comparison-cell">
                                    @if ($isIncluded)
                                        <x-icon icon="lucide:check-circle" class="pricing-comparison-check" />
                                    @else
                                        <x-icon icon="lucide:minus" class="pricing-comparison-minus" />
                                    @endif
                                </td>
                            @endforeach
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</section>

</div>