<?php
use Livewire\Component;
?>

<div>
    <section class="hero5-section" @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Background Shapes --}}
        <div class="hero5-bg-shape hero5-bg-shape-1"></div>
        <div class="hero5-bg-shape hero5-bg-shape-2"></div>

        <div class="hero5-container">
            {{-- Content --}}
            <div class="hero5-content animate-fade-in-up">
                {{-- Badge --}}
                <div class="hero5-badge">
                    <svg class="hero5-badge-star w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                        <path
                            d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z">
                        </path>
                    </svg>
                    <span>{{ $hero['badge'] }}</span>
                </div>

                {{-- Title --}}
                <h1 class="hero5-title">
                    <span class="hero5-title-line">{{ $hero['title'] }}</span>
                    <span class="hero5-title-line"><span
                            class="hero5-title-highlight">{{ $hero['subtitle'] }}</span></span>
                </h1>

                {{-- Description --}}
                <p class="hero5-description">{{ $hero['description'] }}</p>

                {{-- CTA Buttons --}}
                <div class="hero5-cta-group">
                    @foreach ($hero['buttons'] ?? [] as $index => $button)
                        @if ($button['is_transparent'] ?? false)
                            <a href="{{ $button['url'] ?? '#' }}" class="hero5-btn-secondary">
                                @if (!empty($button['icon']))
                                    <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                @endif
                                @if (!empty($button['text']))
                                    <span>{{ $button['text'] }}</span>
                                @endif
                            </a>
                        @else
                            <a href="{{ $button['url'] ?? '#' }}" class="hero5-btn-primary">
                                @if (!empty($button['icon']))
                                    <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                @endif
                                @if (!empty($button['text']))
                                    <span>{{ $button['text'] }}</span>
                                @endif
                            </a>
                        @endif
                    @endforeach
                </div>

                {{-- Stats --}}
                @if (!empty($hero['stats']))
                    <div class="hero5-stats">
                        @foreach (array_slice($hero['stats'], 0, 3) as $stat)
                            <div class="hero5-stat-item">
                                @if (!empty($stat['icon']))
                                    <div class="hero5-stat-icon">
                                        <x-icon icon="{{ $stat['icon'] }}" class="w-5 h-5" />
                                    </div>
                                @endif
                                <div class="hero5-stat-value">{{ $stat['value'] }}</div>
                                <div class="hero5-stat-label">{{ $stat['label'] }}</div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>

            {{-- Image Section --}}
            <div class="hero5-image-section">
                <div class="hero5-image-stack animate-fade-in-up delay-200">
                    {{-- Decorative Ring --}}
                    <div class="hero5-deco-ring"></div>

                    {{-- Main Image --}}
                    <div class="hero5-image-main">
                        <img src="{{ $hero['hero_image_url'] ?? ($hero['hero_image'] ?? 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600&h=500&fit=crop') }}"
                            alt="Professional Laundry Service" loading="lazy">
                    </div>

                    {{-- Floating Cards --}}
                    @foreach ($hero['floating_cards'] ?? [] as $index => $card)
                        @if ($index === 0)
                            <div class="hero5-float-badge animate-bounce-soft">
                                <div class="hero5-float-badge-icon">
                                    <x-icon icon="{{ $card['icon'] ?? 'heroicons:clock' }}" class="w-5 h-5" />
                                </div>
                                <div>
                                    <p class="hero5-float-badge-text">{{ $card['title'] ?? '' }}</p>
                                    <p class="hero5-float-badge-sub">{{ $card['subtitle'] ?? '' }}</p>
                                </div>
                            </div>
                        @else
                            <div class="hero5-float-card animate-bounce-soft delay-300">
                                <div class="hero5-float-card-icon">
                                    <x-icon icon="{{ $card['icon'] ?? 'heroicons:check' }}"
                                        class="w-6 h-6 text-white" />
                                </div>
                                <div>
                                    <p class="hero5-float-card-title">{{ $card['title'] ?? '' }}</p>
                                    <p class="hero5-float-card-subtitle">{{ $card['subtitle'] ?? '' }}</p>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
        </div>
    </section>

    
</div>