<?php
use Livewire\Component;
?>

<div>
<section id="services" class="services-horizontal-section {{ $isWhiteBackground ? 'services-horizontal-white' : 'services-horizontal-gray' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    {{-- Background Decoration --}}
    <div class="services-horizontal-bg">
        <div class="services-horizontal-circle services-horizontal-circle-1"></div>
        <div class="services-horizontal-circle services-horizontal-circle-2"></div>
        <div class="services-horizontal-line"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        {{-- Section Header --}}
        <div class="services-horizontal-header">
            <div class="services-horizontal-header-left">
                <span class="services-horizontal-badge">{{ $section['badge'] }}</span>
                <h2 class="services-horizontal-title">{{ $section['title'] }}</h2>
            </div>
            <div class="services-horizontal-header-right">
                <p class="services-horizontal-subtitle">{{ $section['subtitle'] }}</p>
            </div>
        </div>

        {{-- Services List --}}
        <div class="services-horizontal-list">
            @foreach ($items as $index => $item)
                <div class="services-horizontal-item scroll-animate" style="animation-delay: {{ $index * 100 }}ms">
                    {{-- Left: Icon & Number --}}
                    <div class="services-horizontal-icon-wrap">
                        <div class="services-horizontal-icon">
                            <x-icon icon="{{ $item['icon'] ?? 'heroicons:sparkles' }}" class="w-8 h-8" />
                        </div>
                        <div class="services-horizontal-connector"></div>
                    </div>

                    {{-- Center: Content --}}
                    <div class="services-horizontal-content">
                        <div class="services-horizontal-content-top">
                            <h3 class="services-horizontal-item-title">{{ $item['title'] ?? '' }}</h3>
                            @if (!empty($item['price']))
                                <span class="services-horizontal-price">{{ $item['price'] }}</span>
                            @endif
                        </div>
                        <p class="services-horizontal-desc">{{ $item['description'] ?? '' }}</p>

                        {{-- Features in a row --}}
                        @if (!empty($item['features']))
                            <div class="services-horizontal-features">
                                @foreach ($item['features'] as $feature)
                                    <span class="services-horizontal-feature">
                                        <x-icon icon="lucide:check" class="w-3.5 h-3.5" />
                                        <span>{{ is_array($feature) ? ($feature['text'] ?? '') : $feature }}</span>
                                    </span>
                                @endforeach
                            </div>
                        @endif
                    </div>

                    {{-- Right: Action --}}
                    @if (!empty($item['button_text']) && !empty($item['button_url']))
                        <div class="services-horizontal-action">
                            <a href="{{ $item['button_url'] }}" class="services-horizontal-btn">
                                <span>{{ $item['button_text'] }}</span>
                                <x-icon icon="{{ $item['button_icon'] ?? 'lucide:arrow-right' }}" class="w-4 h-4" />
                            </a>
                        </div>
                    @endif
                </div>
            @endforeach
        </div>
    </div>
</section>


</div>