<?php
use Livewire\Component;
?>

<div>
<section id="services" class="services-bento-section {{ $isWhiteBackground ? 'services-bento-white' : 'services-bento-gray' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    {{-- Background Elements --}}
    <div class="services-bento-bg">
        <div class="services-bento-noise"></div>
        <div class="services-bento-gradient services-bento-gradient-1"></div>
        <div class="services-bento-gradient services-bento-gradient-2"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        {{-- Section Header --}}
        <div class="services-bento-header">
            <div class="services-bento-badge">
                <x-icon icon="lucide:grid-3x3" class="w-4 h-4" />
                {{ $section['badge'] }}
            </div>
            <h2 class="services-bento-title">{{ $section['title'] }}</h2>
            <p class="services-bento-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Bento Grid --}}
        <div class="services-bento-grid">
            @foreach ($items as $index => $item)
                @php
                    $sizes = ['large', 'small', 'small', 'medium', 'medium', 'large'];
                    $size = $sizes[$index % count($sizes)];
                @endphp
                <div class="services-bento-card services-bento-card-{{ $size }} scroll-animate" style="animation-delay: {{ $index * 100 }}ms">
                    <div class="services-bento-card-bg"></div>
                    <div class="services-bento-card-inner">
                        {{-- Icon with decorative elements --}}
                        <div class="services-bento-icon-wrapper">
                            <div class="services-bento-icon">
                                <x-icon icon="{{ $item['icon'] ?? 'heroicons:sparkles' }}" class="w-7 h-7" />
                            </div>
                            <div class="services-bento-icon-ring"></div>
                        </div>

                        {{-- Content --}}
                        <div class="services-bento-content">
                            <div class="services-bento-title-row">
                                <h3 class="services-bento-card-title">{{ $item['title'] ?? '' }}</h3>
                                @if (!empty($item['price']))
                                    <span class="services-bento-price">{{ $item['price'] }}</span>
                                @endif
                            </div>
                            <p class="services-bento-desc">{{ $item['description'] ?? '' }}</p>

                            {{-- Features for large/medium cards --}}
                            @if ($size !== 'small' && !empty($item['features']))
                                <div class="services-bento-features">
                                    @foreach ($item['features'] as $feature)
                                        <div class="services-bento-feature">
                                            <x-icon icon="lucide:check-circle" class="w-4 h-4" />
                                            <span>{{ is_array($feature) ? ($feature['text'] ?? '') : $feature }}</span>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>

                        {{-- Button --}}
                        @if (!empty($item['button_text']) && !empty($item['button_url']))
                            <a href="{{ $item['button_url'] }}" class="services-bento-btn">
                                <span>{{ $item['button_text'] }}</span>
                                <x-icon icon="{{ $item['button_icon'] ?? 'lucide:arrow-up-right' }}" class="w-4 h-4" />
                            </a>
                        @endif

                        {{-- Decorative corner --}}
                        <div class="services-bento-corner"></div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>


</div>