<?php
use Livewire\Component;
?>

@php
    $textColorMode = $section['text_color_mode'] ?? 'auto';
    $textColorClass = match($textColorMode) {
        'light' => 'header1-text-light',
        'dark' => 'header1-text-dark',
        default => '',
    };
    $isSolidHeader = !($section['transparent'] ?? true);
@endphp
<div>
{{-- Header Style 1: Top Bar + Main Header --}}
<div id="header" class="{{ $section['sticky'] ?? true ? 'fixed' : 'relative' }} top-0 left-0 right-0 z-50 transition-all duration-300 {{ $isSolidHeader ? 'header1-solid' : 'header1-transparent' }} {{ $textColorClass }}"
    data-transparent="{{ $isSolidHeader ? 'false' : 'true' }}"
    data-text-color-mode="{{ $textColorMode }}"
    data-solid="{{ $isSolidHeader ? 'true' : 'false' }}">
    {{-- Top Bar --}}
    <div class="header1-topbar hidden lg:block">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-10 text-sm">
                {{-- Left: Contact Info --}}
                <div class="flex items-center gap-6">
                    <a href="tel:{{ $company['phone'] ?? '' }}" class="header1-topbar-link flex items-center gap-2">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                            </path>
                        </svg>
                        <span>{{ $company['phone'] ?? '+1 (555) 123-4567' }}</span>
                    </a>
                    <a href="mailto:{{ $company['email'] ?? '' }}" class="header1-topbar-link flex items-center gap-2">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                            </path>
                        </svg>
                        <span>{{ $company['email'] ?? 'hello@washville.com' }}</span>
                    </a>
                </div>

                {{-- Right: Hours & Theme Toggle --}}
                <div class="flex items-center gap-6">
                    <div class="flex items-center gap-2">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <span>{{ $company['hours'] ?? 'Mon-Sat: 7AM - 9PM' }}</span>
                    </div>
                    {{-- Theme Toggle - Hidden for now, only light mode supported
                    @if ($section['show_theme_toggle'] ?? true)
                        <button id="theme-toggle" class="header1-theme-toggle" aria-label="Toggle theme">
                            <svg class="sun-icon w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z">
                                </path>
                            </svg>
                            <svg class="moon-icon w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z">
                                </path>
                            </svg>
                        </button>
                    @endif
                    --}}
                </div>
            </div>
        </div>
    </div>

    {{-- Main Header --}}
    <header class="header1-main">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-20">
                {{-- Logo with theme mode support based on header_logo_type setting --}}
                @php
                    $headerLogoType = $company['header_logo_type'] ?? 'logo_with_name';
                    $showName = in_array($headerLogoType, ['logo_with_name', 'light_dark_with_name']);
                    $useFullLogo = in_array($headerLogoType, ['light_dark_with_name', 'light_dark_only']);
                @endphp
                <a href="{{ $homeUrl }}" wire:navigate class="flex items-center gap-3 group">
                    @if ($useFullLogo)
                        {{-- Full Logo (Light/Dark based on theme) --}}
                        <img src="{{ $company['light_logo'] ?? asset('images/light.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                            class="h-12 w-auto transition-transform group-hover:scale-105 dark:hidden" />
                        <img src="{{ $company['dark_logo'] ?? asset('images/dark.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                            class="h-12 w-auto transition-transform group-hover:scale-105 hidden dark:block" />
                    @else
                        {{-- Small Logo (Light/Dark based on theme) --}}
                        <img src="{{ $company['light_logo_small'] ?? asset('images/small_light.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                            class="h-10 w-auto transition-transform group-hover:scale-105 dark:hidden" />
                        <img src="{{ $company['dark_logo_small'] ?? asset('images/small_dark.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                            class="h-10 w-auto transition-transform group-hover:scale-105 hidden dark:block" />
                    @endif

                    @if ($showName)
                        <div class="flex flex-col">
                            <span
                                class="header1-logo-text text-xl font-bold leading-tight">{{ $company['name'] ?? 'Washville' }}</span>
                            <span
                                class="header1-logo-tagline text-xs">{{ $company['tagline'] ?? 'Premium Laundry Service' }}</span>
                        </div>
                    @endif
                </a>

                {{-- Desktop Navigation --}}
                <nav class="hidden lg:flex items-center gap-1">
                    @forelse ($navItems as $index => $item)
                        @if ($index < 4)
                            <a href="{{ $item['url'] }}" wire:navigate
                                class="header1-nav-link" data-page="{{ $item['page_key'] }}">
                                {{ $item['name'] }}
                            </a>
                        @endif
                    @empty
                        {{-- Fallback to static nav if no dynamic items --}}
                        <a href="{{ $homeUrl }}#services" wire:navigate class="header1-nav-link"
                            data-section="services">
                            {{ $nav['services'] ?? 'Services' }}
                        </a>
                        <a href="{{ $homeUrl }}#how-it-works" wire:navigate class="header1-nav-link"
                            data-section="how-it-works">
                            {{ $nav['how_it_works'] ?? 'How It Works' }}
                        </a>
                        <a href="{{ $homeUrl }}#pricing" wire:navigate class="header1-nav-link"
                            data-section="pricing">
                            {{ $nav['pricing'] ?? 'Pricing' }}
                        </a>
                        <a href="{{ $homeUrl }}#testimonials" wire:navigate class="header1-nav-link"
                            data-section="testimonials">
                            {{ $nav['reviews'] ?? 'Reviews' }}
                        </a>
                        <a href="{{ $homeUrl }}#faq" wire:navigate class="header1-nav-link" data-section="faq">
                            {{ $nav['faq'] ?? 'FAQ' }}
                        </a>
                        <a href="{{ $homeUrl }}#contact" wire:navigate class="header1-nav-link"
                            data-section="contact">
                            {{ $nav['contact'] ?? 'Contact' }}
                        </a>
                    @endforelse

                    {{-- More Dropdown for remaining items --}}
                    @if (count($navItems) > 4)
                        <div class="relative" x-data="{ open: false }">
                            <button @click="open = !open" @click.away="open = false"
                                class="header1-nav-link flex items-center gap-1.5">
                                {{ $section['more_text'] ?? 'More' }}
                                <svg class="w-4 h-4 transition-transform duration-200" :class="{ 'rotate-180': open }"
                                    fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </button>
                            <div x-show="open"
                                x-transition:enter="transition ease-out duration-200"
                                x-transition:enter-start="opacity-0 translate-y-2"
                                x-transition:enter-end="opacity-100 translate-y-0"
                                x-transition:leave="transition ease-in duration-150"
                                x-transition:leave-start="opacity-100 translate-y-0"
                                x-transition:leave-end="opacity-0 translate-y-2"
                                class="header1-more-dropdown absolute top-full left-0 mt-2 min-w-[180px] rounded-lg shadow-lg bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 z-50 py-1.5 overflow-hidden"
                                style="display: none;">
                                @foreach ($navItems as $index => $item)
                                    @if ($index >= 4)
                                        <a href="{{ $item['url'] }}" wire:navigate
                                            data-page="{{ $item['page_key'] }}"
                                            class="header1-more-item group flex items-center justify-between gap-2 px-4 py-2.5 text-sm text-gray-600 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700/50 hover:text-primary-600 dark:hover:text-primary-400 transition-colors duration-150">
                                            <span>{{ $item['name'] }}</span>
                                            <svg class="w-3.5 h-3.5 opacity-0 -translate-x-1 group-hover:opacity-100 group-hover:translate-x-0 transition-all duration-150 text-primary-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                            </svg>
                                        </a>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    @endif
                </nav>

                {{-- CTA Button & Language Dropdown --}}
                <div class="hidden lg:flex items-center gap-3">
                    {{-- Language Dropdown --}}
                    @if (count($languages ?? []) > 1)
                        <div class="relative" x-data="{ open: false }">
                            <button @click="open = !open" @click.away="open = false"
                                class="flex items-center gap-1 px-2 py-1 rounded-lg text-sm font-medium header1-lang-btn transition-colors"
                                aria-label="Select language">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9">
                                    </path>
                                </svg>
                                <span class="uppercase" id="current-lang-display">{{ $currentLangKey }}</span>
                                <svg class="w-3 h-3 transition-transform" :class="{ 'rotate-180': open }"
                                    fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </button>
                            <div x-show="open" x-transition:enter="transition ease-out duration-100"
                                x-transition:enter-start="transform opacity-0 scale-95"
                                x-transition:enter-end="transform opacity-100 scale-100"
                                x-transition:leave="transition ease-in duration-75"
                                x-transition:leave-start="transform opacity-100 scale-100"
                                x-transition:leave-end="transform opacity-0 scale-95"
                                class="absolute right-0 mt-2 w-40 rounded-lg shadow-lg bg-white dark:bg-gray-800 ring-1 ring-black ring-opacity-5 z-50 py-1"
                                style="display: none;">
                                @foreach ($languages as $lang)
                                    <button type="button" wire:click="changeLanguage('{{ $lang['key'] }}')"
                                        class="w-full text-left px-4 py-2 text-sm hover:bg-gray-100 dark:hover:bg-gray-700 flex items-center gap-2 {{ $currentLangKey === $lang['key'] ? 'bg-primary-50 dark:bg-primary-900/20 text-primary-600' : 'text-gray-700 dark:text-gray-300' }}">
                                        @if (!empty($lang['flag_code']))
                                            <span class="text-lg">{{ $lang['flag_emoji'] ?? '' }}</span>
                                        @endif
                                        <span>{{ $lang['name'] }}</span>
                                        @if ($currentLangKey === $lang['key'])
                                            <svg class="w-4 h-4 ml-auto text-primary-600" fill="none"
                                                stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M5 13l4 4L19 7"></path>
                                            </svg>
                                        @endif
                                    </button>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    @if (!empty($section['cta_buttons']) && is_array($section['cta_buttons']))
                        @foreach ($section['cta_buttons'] as $btnIndex => $ctaBtn)
                            @if (is_array($ctaBtn) && (!empty($ctaBtn['text']) || !empty($ctaBtn['icon'])))
                                <a href="{{ $ctaBtn['url'] ?? '#contact' }}"
                                    class="header1-cta-btn flex items-center gap-2"
                                    @if (str_starts_with($ctaBtn['url'] ?? '#contact', '#')) wire:navigate data-section="{{ ltrim($ctaBtn['url'] ?? '#contact', '#') }}" @endif>
                                    @if (!empty($ctaBtn['icon']))<x-icon :icon="$ctaBtn['icon']" class="w-5 h-5" />@endif
                                    @if (!empty($ctaBtn['text']))<span>{{ $ctaBtn['text'] }}</span>@endif
                                </a>
                            @endif
                        @endforeach
                    @endif
                </div>

                {{-- Mobile Menu Button --}}
                <div class="flex items-center gap-3 lg:hidden">
                    {{-- Mobile Theme Toggle - Hidden for now, only light mode supported
                    @if ($section['show_theme_toggle'] ?? true)
                        <button id="theme-toggle-mobile" class="header1-theme-toggle-mobile"
                            aria-label="Toggle theme">
                            <svg class="sun-icon w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z">
                                </path>
                            </svg>
                            <svg class="moon-icon w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z">
                                </path>
                            </svg>
                        </button>
                    @endif
                    --}}
                    {{-- Hamburger Menu --}}
                    <button id="mobile-menu-btn" class="header1-mobile-btn">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4 6h16M4 12h16M4 18h16"></path>
                        </svg>
                    </button>
                </div>
            </div>
        </div>
    </header>
</div>

{{-- Mobile Menu Slide-in Panel --}}
<div id="mobile-menu" class="header1-mobile-menu">
    <div class="flex flex-col h-full">
        {{-- Mobile Menu Header with header_logo_type support --}}
        @php
            $mobileHeaderLogoType = $company['header_logo_type'] ?? 'logo_with_name';
            $mobileShowName = in_array($mobileHeaderLogoType, ['logo_with_name', 'light_dark_with_name']);
            $mobileUseFullLogo = in_array($mobileHeaderLogoType, ['light_dark_with_name', 'light_dark_only']);
        @endphp
        <div class="header1-mobile-header">
            <div class="flex items-center gap-3">
                @if ($mobileUseFullLogo)
                    {{-- Full Logo for mobile --}}
                    <img src="{{ $company['light_logo'] ?? asset('images/light.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="h-10 w-auto dark:hidden" />
                    <img src="{{ $company['dark_logo'] ?? asset('images/dark.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="h-10 w-auto hidden dark:block" />
                @else
                    {{-- Small Logo for mobile --}}
                    <img src="{{ $company['light_logo_small'] ?? asset('images/small_light.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="h-8 w-auto dark:hidden" />
                    <img src="{{ $company['dark_logo_small'] ?? asset('images/small_dark.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="h-8 w-auto hidden dark:block" />
                @endif

                @if ($mobileShowName)
                    <span class="text-lg font-bold">{{ $company['name'] ?? 'Washville' }}</span>
                @endif
            </div>
            <button id="mobile-menu-close" class="header1-mobile-close">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                    </path>
                </svg>
            </button>
        </div>

        {{-- Mobile Navigation --}}
        <nav class="flex-1 overflow-y-auto py-4">
            @forelse ($navItems as $item)
                <a href="{{ $item['url'] }}" data-page="{{ $item['page_key'] }}"
                    class="header1-mobile-link mobile-menu-link">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                    <span>{{ $item['name'] }}</span>
                </a>
            @empty
                {{-- Fallback to static nav if no dynamic items --}}
                <a href="{{ $homeUrl }}#services" data-section="services"
                    class="header1-mobile-link mobile-menu-link">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15">
                        </path>
                    </svg>
                    <span>{{ $nav['services'] ?? 'Services' }}</span>
                </a>
                <a href="{{ $homeUrl }}#how-it-works" data-section="how-it-works"
                    class="header1-mobile-link mobile-menu-link">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4">
                        </path>
                    </svg>
                    <span>{{ $nav['how_it_works'] ?? 'How It Works' }}</span>
                </a>
                <a href="{{ $homeUrl }}#pricing" data-section="pricing"
                    class="header1-mobile-link mobile-menu-link">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z">
                        </path>
                    </svg>
                    <span>{{ $nav['pricing'] ?? 'Pricing' }}</span>
                </a>
                <a href="{{ $homeUrl }}#testimonials" data-section="testimonials"
                    class="header1-mobile-link mobile-menu-link">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z">
                        </path>
                    </svg>
                    <span>{{ $nav['reviews'] ?? 'Reviews' }}</span>
                </a>
                <a href="{{ $homeUrl }}#faq" data-section="faq" class="header1-mobile-link mobile-menu-link">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z">
                        </path>
                    </svg>
                    <span>{{ $nav['faq'] ?? 'FAQ' }}</span>
                </a>
                <a href="{{ $homeUrl }}#contact" data-section="contact"
                    class="header1-mobile-link mobile-menu-link">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                        </path>
                    </svg>
                    <span>{{ $nav['contact'] ?? 'Contact' }}</span>
                </a>
            @endforelse
        </nav>

        {{-- Mobile Language Selector --}}
        @if (count($languages ?? []) > 1)
            <div class="px-4 py-3 border-t border-gray-200 dark:border-gray-700">
                <p class="text-sm font-medium text-gray-500 dark:text-gray-400 mb-2">Language</p>
                <div class="flex flex-wrap gap-2">
                    @foreach ($languages as $lang)
                        <button type="button" wire:click="changeLanguage('{{ $lang['key'] }}')"
                            class="px-3 py-2 text-sm rounded-lg flex items-center gap-2 {{ $currentLangKey === $lang['key'] ? 'bg-primary-600 text-white' : 'bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300 hover:bg-gray-200 dark:hover:bg-gray-600' }}">
                            @if (!empty($lang['flag_emoji']))
                                <span>{{ $lang['flag_emoji'] }}</span>
                            @endif
                            <span>{{ $lang['name'] }}</span>
                        </button>
                    @endforeach
                </div>
            </div>
        @endif

        {{-- Mobile Menu Footer --}}
        <div class="header1-mobile-footer">
            {{-- Contact Info --}}
            <div class="space-y-3 mb-4">
                <a href="tel:{{ $company['phone'] ?? '' }}" class="header1-mobile-contact">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                        </path>
                    </svg>
                    <span>{{ $company['phone'] ?? '+1 (555) 123-4567' }}</span>
                </a>
                <a href="mailto:{{ $company['email'] ?? '' }}" class="header1-mobile-contact">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                        </path>
                    </svg>
                    <span>{{ $company['email'] ?? 'hello@washville.com' }}</span>
                </a>
            </div>
            {{-- CTA Buttons --}}
            @if (!empty($section['cta_buttons']) && is_array($section['cta_buttons']))
                <div class="space-y-2">
                    @foreach ($section['cta_buttons'] as $btnIndex => $ctaBtn)
                        @if (is_array($ctaBtn) && (!empty($ctaBtn['text']) || !empty($ctaBtn['icon'])))
                            <a href="{{ $ctaBtn['url'] ?? '#contact' }}"
                                @if (str_starts_with($ctaBtn['url'] ?? '#contact', '#')) data-section="{{ ltrim($ctaBtn['url'] ?? '#contact', '#') }}" @endif
                                class="header1-mobile-cta mobile-menu-link flex items-center justify-center gap-2">
                                @if (!empty($ctaBtn['icon']))<x-icon :icon="$ctaBtn['icon']" class="w-5 h-5" />@endif
                                @if (!empty($ctaBtn['text']))<span>{{ $ctaBtn['text'] }}</span>@endif
                            </a>
                        @endif
                    @endforeach
                </div>
            @endif
        </div>
    </div>
</div>

{{-- Overlay for mobile menu --}}
<div id="mobile-menu-overlay" class="header1-overlay"></div>
</div>



{{-- Language Change Script --}}
@script
    <script>
        // Listen for Livewire language-changed event and reload the page
        // Remove 'lang' query parameter if present before reload
        $wire.on('language-changed', () => {
            const url = new URL(window.location.href);
            if (url.searchParams.has('lang')) {
                url.searchParams.delete('lang');
                window.location.href = url.toString();
            } else {
                window.location.reload();
            }
        });
    </script>
@endscript

</div>