<?php
use Livewire\Component;
?>

<div>
    <section id="how-it-works"
        class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }} overflow-hidden"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Section Header --}}
            <div class="text-center mb-16">
                <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                <h2 class="section-title">{{ $section['title'] }}</h2>
                <p class="section-subtitle">{{ $section['subtitle'] }}</p>
            </div>

            {{-- Numbered Steps Container --}}
            <div class="hiw-numbered">
                {{-- Progress Line --}}
                <div class="hiw-numbered-line">
                    <div class="hiw-numbered-line-fill"></div>
                </div>

                {{-- Steps --}}
                <div class="hiw-numbered-steps">
                    @foreach ($items as $index => $step)
                        <div class="scroll-animate hiw-numbered-item">
                            {{-- Number Circle --}}
                            <div class="hiw-numbered-circle">
                                <span class="hiw-numbered-num">{{ $step['step'] }}</span>
                            </div>

                            {{-- Card --}}
                            <div class="hiw-numbered-card">
                                {{-- Icon --}}
                                <div class="hiw-numbered-icon">
                                    <x-icon icon="{{ $step['icon'] ?? 'heroicons:home' }}"
                                        class="hiw-numbered-icon-svg w-6 h-6" />
                                </div>

                                {{-- Content --}}
                                <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">
                                    {{ $step['title'] }}
                                </h3>
                                <p class="text-gray-600 dark:text-gray-400 text-sm">
                                    {{ $step['description'] }}
                                </p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>

    
</div>