<?php
use Livewire\Component;
?>

<div>
<section class="section relative promo-bg" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    {{-- Background Shapes --}}
    <div class="promo-shapes">
        <div class="promo-shape promo-shape-1"></div>
        <div class="promo-shape promo-shape-2"></div>
        <div class="promo-shape promo-shape-3"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-24">
        <div class="promo-content">
                {{-- Icon --}}
                @if(!empty($section['icon']))
                <div class="promo-icon-badge scroll-animate" data-animation="zoom-in">
                    <x-icon icon="{{ $section['icon'] }}" class="w-10 h-10" />
                </div>
                @endif

                {{-- Title Badge --}}
                @if(!empty($section['title']))
                <div class="scroll-animate" data-animation="fade-down" style="animation-delay: 0.1s">
                    <span class="promo-title-badge">{{ $section['title'] }}</span>
                </div>
                @endif

                {{-- Headline --}}
                @if(!empty($section['headline']))
                <h2 class="promo-headline scroll-animate" data-animation="fade-up" style="animation-delay: 0.2s">
                    {{ $section['headline'] }}
                </h2>
                @endif

                {{-- Subtitle --}}
                @if(!empty($section['subtitle']))
                <p class="promo-subtitle scroll-animate" data-animation="fade-up" style="animation-delay: 0.25s">
                    {{ $section['subtitle'] }}
                </p>
                @endif

                {{-- Description --}}
                @if(!empty($section['description']))
                <p class="promo-description scroll-animate" data-animation="fade-up" style="animation-delay: 0.3s">
                    {{ $section['description'] }}
                </p>
                @endif

                {{-- Promo Code Box --}}
                @if(($section['show_promo_code'] ?? false) && !empty($section['promo_code']))
                <div class="promo-code-wrapper scroll-animate" data-animation="zoom-in" style="animation-delay: 0.4s" x-data="{ copied: false }">
                    <p class="promo-code-label">{{ $section['promo_code_label'] ?? 'Use promo code:' }}</p>
                    <button
                        @click="navigator.clipboard.writeText('{{ $section['promo_code'] }}'); copied = true; setTimeout(() => copied = false, 2000)"
                        class="promo-code-box group">
                        <span class="promo-code-text">{{ $section['promo_code'] }}</span>
                        <div class="flex items-center gap-2">
                            <svg x-show="!copied" class="w-5 h-5 promo-copy-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"/>
                            </svg>
                            <svg x-show="copied" x-cloak class="w-5 h-5 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                        </div>
                    </button>
                    <p x-show="copied" x-transition class="text-green-400 text-sm mt-2">{{ $section['copied_message'] ?? 'Copied to clipboard!' }}</p>
                </div>
                @endif

                {{-- Countdown Timer --}}
                @if(($section['show_countdown'] ?? false) && !empty($section['expiry_date']))
                <div class="promo-countdown-wrapper scroll-animate" data-animation="fade-up" style="animation-delay: 0.5s" data-countdown-timer data-expiry="{{ $section['expiry_date'] }}">
                    <p class="promo-countdown-label">{{ $section['countdown_label'] ?? 'Offer ends in:' }}</p>
                    <div class="promo-countdown">
                        <div class="promo-countdown-item">
                            <span class="promo-countdown-value" data-countdown-days>00</span>
                            <span class="promo-countdown-unit">{{ $section['countdown_days_label'] ?? 'Days' }}</span>
                        </div>
                        <span class="promo-countdown-sep">:</span>
                        <div class="promo-countdown-item">
                            <span class="promo-countdown-value" data-countdown-hours>00</span>
                            <span class="promo-countdown-unit">{{ $section['countdown_hours_label'] ?? 'Hrs' }}</span>
                        </div>
                        <span class="promo-countdown-sep">:</span>
                        <div class="promo-countdown-item">
                            <span class="promo-countdown-value" data-countdown-minutes>00</span>
                            <span class="promo-countdown-unit">{{ $section['countdown_minutes_label'] ?? 'Mins' }}</span>
                        </div>
                        <span class="promo-countdown-sep">:</span>
                        <div class="promo-countdown-item">
                            <span class="promo-countdown-value" data-countdown-seconds>00</span>
                            <span class="promo-countdown-unit">{{ $section['countdown_seconds_label'] ?? 'Secs' }}</span>
                        </div>
                    </div>
                </div>
                @endif

                {{-- CTA Button --}}
                @if(!empty($section['cta_text']))
                <div class="promo-cta-wrapper scroll-animate" data-animation="zoom-in" style="animation-delay: 0.6s">
                    <a href="{{ $section['cta_url'] ?? '#contact' }}" class="promo-cta-btn">
                        <span>{{ $section['cta_text'] }}</span>
                        <svg class="w-4 h-4 rtl:rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                        </svg>
                    </a>
                </div>
                @endif

                {{-- Terms --}}
                @if(!empty($section['terms']))
                <p class="promo-terms scroll-animate" data-animation="fade-up" style="animation-delay: 0.7s">
                    {{ $section['terms'] }}
                </p>
                @endif
        </div>
    </div>
</section>

@if(($section['show_countdown'] ?? false) && !empty($section['expiry_date']))
@script
<script>
(function() {
    const timers = document.querySelectorAll('[data-countdown-timer]');

    timers.forEach(function(wrapper) {
        if (wrapper.dataset.countdownInitialized) return;
        wrapper.dataset.countdownInitialized = 'true';

        const endDateStr = (wrapper.getAttribute('data-expiry') || '').replace(' ', 'T');
        if (!endDateStr) return;

        const daysEl = wrapper.querySelector('[data-countdown-days]');
        const hoursEl = wrapper.querySelector('[data-countdown-hours]');
        const minutesEl = wrapper.querySelector('[data-countdown-minutes]');
        const secondsEl = wrapper.querySelector('[data-countdown-seconds]');

        if (!daysEl || !hoursEl || !minutesEl || !secondsEl) return;

        function updateCountdown() {
            const end = new Date(endDateStr).getTime();
            const now = new Date().getTime();
            const diff = end - now;

            if (diff > 0) {
                daysEl.textContent = String(Math.floor(diff / (1000 * 60 * 60 * 24))).padStart(2, '0');
                hoursEl.textContent = String(Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60))).padStart(2, '0');
                minutesEl.textContent = String(Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60))).padStart(2, '0');
                secondsEl.textContent = String(Math.floor((diff % (1000 * 60)) / 1000)).padStart(2, '0');
            } else {
                wrapper.style.display = 'none';
            }
        }

        updateCountdown();
        setInterval(updateCountdown, 1000);
    });
})();
</script>
@endscript
@endif


</div>