<?php
use Livewire\Component;
?>

<div>
    

    <section id="team"
        class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Section Header --}}
            <div class="text-center mb-16 scroll-animate" data-animation="fade-up">
                @if (!empty($section['badge']))
                    <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                @endif
                <h2 class="section-title">{{ $section['title'] }}</h2>
                @if (!empty($section['subtitle']))
                    <p class="section-subtitle">{{ $section['subtitle'] }}</p>
                @endif
            </div>

            {{-- Team Grid --}}
            <div class="space-y-6">
                @foreach ($items as $index => $member)
                    <div class="team-grid2-card bg-white dark:bg-gray-800 shadow-lg scroll-animate"
                        data-animation="fade-up" style="animation-delay: {{ $index * 100 }}ms">
                        {{-- Image --}}
                        <div class="team-grid2-image-wrapper">
                            @php
                                $imageUrl = $member['image_url'] ?? ($member['image'] ?? null);
                                $defaultPlaceholder =
                                    'https://ui-avatars.com/api/?name=' .
                                    urlencode($member['name'] ?? 'Team') .
                                    '&size=300&background=random&color=fff&bold=true';
                            @endphp
                            <img src="{{ $imageUrl ?: $defaultPlaceholder }}" alt="{{ $member['name'] ?? '' }}"
                                loading="lazy">
                        </div>

                        {{-- Content --}}
                        <div class="team-grid2-content">
                            @if (!empty($member['position']) || !empty($member['role']))
                                <span class="team-grid2-position">
                                    {{ $member['position'] ?? $member['role'] }}
                                </span>
                            @endif

                            <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">
                                {{ $member['name'] ?? '' }}
                            </h3>

                            @if (!empty($member['bio']))
                                <p class="text-gray-600 dark:text-gray-400 text-sm leading-relaxed mb-4">
                                    {{ $member['bio'] }}
                                </p>
                            @endif

                            @if (!empty($member['social_links']))
                                <div class="team-grid2-social flex gap-2">
                                    @foreach ($member['social_links'] as $social)
                                        <a href="{{ $social['url'] ?? '#' }}" target="_blank" rel="noopener">
                                            <x-icon icon="{{ $social['icon'] ?? 'mdi:link' }}" class="w-4 h-4" />
                                        </a>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
</div>