<?php
use Livewire\Component;
?>

<div>
    <section class="hero2-section" @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        <div class="hero2-container">
            {{-- Content Side --}}
            <div class="hero2-content-side">
                <div class="hero2-content-inner animate-fade-in-up">
                    {{-- Badge --}}
                    <div class="hero2-badge">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd"
                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                clip-rule="evenodd"></path>
                        </svg>
                        <span>{{ $hero['badge'] }}</span>
                    </div>

                    {{-- Title --}}
                    <h1 class="hero2-title">{{ $hero['title'] }}</h1>
                    <p class="hero2-subtitle">{{ $hero['subtitle'] }}</p>

                    {{-- Description --}}
                    <p class="hero2-description">{{ $hero['description'] }}</p>

                    {{-- CTA Buttons --}}
                    <div class="hero2-cta-group">
                        @foreach ($hero['buttons'] ?? [] as $index => $button)
                            @if ($button['is_transparent'] ?? false)
                                <a href="{{ $button['url'] ?? '#' }}" class="hero2-btn-secondary">
                                    @if (!empty($button['icon']))
                                        <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                    @endif
                                    @if (!empty($button['text']))
                                        <span>{{ $button['text'] }}</span>
                                    @endif
                                </a>
                            @else
                                <a href="{{ $button['url'] ?? '#' }}" class="hero2-btn-primary">
                                    @if (!empty($button['icon']))
                                        <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                    @endif
                                    @if (!empty($button['text']))
                                        <span>{{ $button['text'] }}</span>
                                    @endif
                                </a>
                            @endif
                        @endforeach
                    </div>

                    {{-- Stats --}}
                    @if (!empty($hero['stats']))
                        <div class="hero2-stats">
                            @foreach ($hero['stats'] as $stat)
                                <div class="hero2-stat-item">
                                    @if (!empty($stat['icon']))
                                        <div class="hero2-stat-icon">
                                            <x-icon icon="{{ $stat['icon'] }}" class="w-5 h-5" />
                                        </div>
                                    @endif
                                    <div class="hero2-stat-value">{{ $stat['value'] }}</div>
                                    <div class="hero2-stat-label">{{ $stat['label'] }}</div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>

            {{-- Image Side --}}
            <div class="hero2-image-side">
                <img src="{{ $hero['hero_image_url'] ?? ($hero['hero_image'] ?? 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600&h=500&fit=crop') }}"
                    alt="Professional Laundry Service" loading="lazy">
                <div class="hero2-image-overlay"></div>

                {{-- Decorative Dots --}}
                <div class="hero2-deco-dots"></div>

                {{-- Floating Cards --}}
                @foreach ($hero['floating_cards'] ?? [] as $index => $card)
                    <div
                        class="hero2-float-card hero2-float-card-{{ $index + 1 }} animate-bounce-soft {{ $index > 0 ? 'delay-300' : '' }}">
                        <div
                            class="hero2-float-icon {{ $index === 0 ? 'hero2-float-icon-primary' : 'hero2-float-icon-secondary' }}">
                            <x-icon icon="{{ $card['icon'] ?? 'heroicons:check' }}" class="w-6 h-6" />
                        </div>
                        <div>
                            <p class="hero2-float-title">{{ $card['title'] ?? '' }}</p>
                            <p class="hero2-float-subtitle">{{ $card['subtitle'] ?? '' }}</p>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>

    
</div>