<?php
use Livewire\Component;
?>

<div>
<section id="pricing" class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Header --}}
        <div class="text-center mb-16">
            <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
            <h2 class="section-title">{{ $section['title'] }}</h2>
            <p class="section-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Pricing Cards --}}
        <div class="grid md:grid-cols-3 gap-8 items-stretch">
            @foreach ($items as $index => $plan)
                <div class="scroll-animate pricing-card {{ $plan['popular'] ? 'popular shadow-2xl' : 'shadow-lg' }}">
                    @if ($plan['popular'])
                        <div class="absolute -top-4 left-1/2 -translate-x-1/2">
                            <span class="badge badge-popular px-4 py-1">{{ $section['popular_badge'] }}</span>
                        </div>
                    @endif

                    <div class="text-center mb-8">
                        <h3 class="pricing-plan-name {{ $plan['popular'] ? 'popular' : '' }}">
                            {{ $plan['name'] }}
                        </h3>
                        <p class="pricing-plan-desc {{ $plan['popular'] ? 'popular' : '' }}">
                            {{ $plan['description'] }}
                        </p>
                        <div class="flex items-baseline justify-center">
                            <span class="pricing-plan-price {{ $plan['popular'] ? 'popular' : '' }}">
                                {{ $section['currency_symbol'] ?? '$' }}{{ $plan['price'] }}
                            </span>
                            <span class="pricing-plan-period {{ $plan['popular'] ? 'popular' : '' }}">
                                /{{ $plan['period'] }}
                            </span>
                        </div>
                    </div>

                    <ul class="pricing-features-list">
                        @foreach ($plan['features'] as $feature)
                            @php
                                $featureIcon = is_array($feature) ? ($feature['icon'] ?? '') : '';
                                $featureText = is_array($feature) ? ($feature['text'] ?? '') : $feature;
                                $isIncluded = is_array($feature) ? ($feature['is_included'] ?? $feature['included'] ?? true) : true;
                            @endphp
                            <li class="pricing-feature-item {{ !$isIncluded ? 'excluded' : '' }} {{ $plan['popular'] ? 'popular' : '' }}">
                                <span class="pricing-feature-icon {{ !$isIncluded ? 'excluded' : '' }} {{ $plan['popular'] ? 'popular' : '' }}">
                                    @if (!empty($featureIcon))
                                        <x-icon icon="{{ $featureIcon }}" />
                                    @else
                                        @if ($isIncluded)
                                            <x-icon icon="lucide:check" />
                                        @else
                                            <x-icon icon="lucide:x" />
                                        @endif
                                    @endif
                                </span>
                                <span class="pricing-feature-text {{ !$isIncluded ? 'excluded' : '' }} {{ $plan['popular'] ? 'popular' : '' }}">
                                    {{ $featureText }}
                                </span>
                            </li>
                        @endforeach
                    </ul>

                    <a href="{{ $section['cta_button_url'] ?? '#contact' }}" class="btn w-full {{ $plan['popular'] ? 'btn-white' : 'btn-primary' }}">
                        {{ $section['cta_button'] }}
                    </a>
                </div>
            @endforeach
        </div>
    </div>
</section>


</div>