<?php
use Livewire\Component;
?>

<div>
<section id="services" class="services-minimal-section {{ $isWhiteBackground ? 'services-minimal-white' : 'services-minimal-gray' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Header --}}
        <div class="services-minimal-header">
            <span class="services-minimal-badge">{{ $section['badge'] }}</span>
            <h2 class="services-minimal-title">{{ $section['title'] }}</h2>
            <p class="services-minimal-subtitle">{{ $section['subtitle'] }}</p>
            <div class="services-minimal-divider"></div>
        </div>

        {{-- Services Grid --}}
        <div class="services-minimal-grid">
            @foreach ($items as $index => $item)
                <div class="services-minimal-item scroll-animate" style="animation-delay: {{ $index * 100 }}ms">
                    {{-- Left Side - Number & Icon --}}
                    <div class="services-minimal-left">
                        <span class="services-minimal-number">{{ str_pad($index + 1, 2, '0', STR_PAD_LEFT) }}</span>
                        <div class="services-minimal-icon">
                            <x-icon icon="{{ $item['icon'] ?? 'heroicons:sparkles' }}" class="w-6 h-6" />
                        </div>
                    </div>

                    {{-- Right Side - Content --}}
                    <div class="services-minimal-right">
                        <div class="services-minimal-content">
                            <h3 class="services-minimal-item-title">{{ $item['title'] ?? '' }}</h3>
                            <p class="services-minimal-item-desc">{{ $item['description'] ?? '' }}</p>
                        </div>

                        @if (!empty($item['price']))
                            <div class="services-minimal-price">{{ $item['price'] }}</div>
                        @endif

                        @if (!empty($item['button_text']) && !empty($item['button_url']))
                            <a href="{{ $item['button_url'] }}" class="services-minimal-link">
                                <span>{{ $item['button_text'] }}</span>
                                <x-icon icon="{{ $item['button_icon'] ?? 'lucide:arrow-right' }}" class="w-4 h-4" />
                            </a>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>


</div>