<?php
use Livewire\Component;
?>

<div>
    


    <section class="section relative promo-bold-bg"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Bold Geometric Shapes --}}
        <div class="promo-bold-shapes">
            <div class="promo-bold-square promo-bold-square-1"></div>
            <div class="promo-bold-square promo-bold-square-2"></div>
            <div class="promo-bold-square promo-bold-square-3"></div>
            <div class="promo-bold-triangle promo-bold-triangle-1"></div>
            <div class="promo-bold-triangle promo-bold-triangle-2"></div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-24">
            <div class="promo-bold-content">
                {{-- Icon --}}
                <div class="promo-bold-icon">
                    <x-icon icon="{{ $section['icon'] }}" class="w-20 h-20 mx-auto" />
                </div>

                {{-- Badge --}}
                <div class="promo-bold-badge">
                    <span>{{ $section['discount_value'] ?? '50%' }} {{ $section['discount_label'] ?? 'OFF' }}</span>
                </div>

                {{-- Headline --}}
                <h2 class="promo-bold-headline">{{ $section['headline'] }}</h2>

                {{-- Description --}}
                <p class="promo-bold-description">{{ $section['description'] }}</p>

                {{-- Countdown Timer --}}
                @if ($section['show_countdown'] && !empty($section['expiry_date']))
                    <div class="promo-bold-countdown" data-countdown-timer data-expiry="{{ $section['expiry_date'] }}">
                        <div class="promo-bold-countdown-item">
                            <div class="promo-bold-countdown-value" data-countdown-days>00</div>
                            <div class="promo-bold-countdown-label">{{ $section['countdown_days_label'] ?? 'Days' }}
                            </div>
                        </div>
                        <div class="promo-bold-countdown-item">
                            <div class="promo-bold-countdown-value" data-countdown-hours>00</div>
                            <div class="promo-bold-countdown-label">{{ $section['countdown_hours_label'] ?? 'Hrs' }}
                            </div>
                        </div>
                        <div class="promo-bold-countdown-item">
                            <div class="promo-bold-countdown-value" data-countdown-minutes>00</div>
                            <div class="promo-bold-countdown-label">{{ $section['countdown_minutes_label'] ?? 'Mins' }}
                            </div>
                        </div>
                        <div class="promo-bold-countdown-item">
                            <div class="promo-bold-countdown-value" data-countdown-seconds>00</div>
                            <div class="promo-bold-countdown-label">{{ $section['countdown_seconds_label'] ?? 'Secs' }}
                            </div>
                        </div>
                    </div>
                @endif

                {{-- Promo Code --}}
                @if ($section['show_promo_code'] && !empty($section['promo_code']))
                    <div class="promo-bold-code-container">
                        <div class="promo-bold-code-box" x-data="{ copied: false }"
                            @click="navigator.clipboard.writeText('{{ $section['promo_code'] }}'); copied = true; setTimeout(() => copied = false, 2000)">
                            <span class="promo-bold-code-text">{{ $section['promo_code'] }}</span>
                            <x-icon icon="lucide:copy" class="w-4 h-4 text-amber-900" x-show="!copied" />
                            <x-icon icon="lucide:check" class="w-4 h-4 text-green-700" x-show="copied" x-cloak />
                        </div>
                    </div>
                @endif

                {{-- CTA Button --}}
                <a href="{{ $section['cta_url'] }}" class="promo-bold-cta">
                    <span>{{ $section['cta_text'] }}</span>
                    <x-icon icon="lucide:arrow-right" class="w-4 h-4" />
                </a>

                {{-- Terms --}}
                @if (!empty($section['terms']))
                    <p class="promo-bold-terms">{{ $section['terms'] }}</p>
                @endif
            </div>
        </div>
    </section>

    @if (($section['show_countdown'] ?? false) && !empty($section['expiry_date']))
        @script
            <script>
                (function() {
                    const timers = document.querySelectorAll('[data-countdown-timer]');

                    timers.forEach(function(wrapper) {
                        if (wrapper.dataset.countdownInitialized) return;
                        wrapper.dataset.countdownInitialized = 'true';

                        const endDateStr = (wrapper.getAttribute('data-expiry') || '').replace(' ', 'T');
                        if (!endDateStr) return;

                        const daysEl = wrapper.querySelector('[data-countdown-days]');
                        const hoursEl = wrapper.querySelector('[data-countdown-hours]');
                        const minutesEl = wrapper.querySelector('[data-countdown-minutes]');
                        const secondsEl = wrapper.querySelector('[data-countdown-seconds]');

                        if (!daysEl || !hoursEl || !minutesEl || !secondsEl) return;

                        function updateCountdown() {
                            const end = new Date(endDateStr).getTime();
                            const now = new Date().getTime();
                            const diff = end - now;

                            if (diff > 0) {
                                daysEl.textContent = String(Math.floor(diff / (1000 * 60 * 60 * 24))).padStart(2, '0');
                                hoursEl.textContent = String(Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 *
                                    60))).padStart(2, '0');
                                minutesEl.textContent = String(Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60)))
                                    .padStart(2, '0');
                                secondsEl.textContent = String(Math.floor((diff % (1000 * 60)) / 1000)).padStart(2,
                                    '0');
                            } else {
                                wrapper.style.display = 'none';
                            }
                        }

                        updateCountdown();
                        setInterval(updateCountdown, 1000);
                    });
                })();
            </script>
        @endscript
    @endif

</div>