<?php
use Livewire\Component;
?>

<section class="pricing-gradient-section {{ $isWhiteBackground ? 'pricing-gradient-white' : 'pricing-gradient-gray' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="pricing-gradient-bg-shapes">
        <div class="pricing-gradient-shape pricing-gradient-shape-1"></div>
        <div class="pricing-gradient-shape pricing-gradient-shape-2"></div>
    </div>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        <div class="text-center mb-12">
            <span class="pricing-gradient-badge">{{ $section['badge'] }}</span>
            <h2 class="pricing-gradient-title">{{ $section['title'] }}</h2>
            <p class="pricing-gradient-subtitle">{{ $section['subtitle'] }}</p>
        </div>
        <div class="pricing-gradient-grid">
            @foreach ($items as $index => $plan)
                <div class="pricing-gradient-card {{ $plan['popular'] ? 'pricing-gradient-card-popular' : '' }}" style="animation-delay: {{ $index * 100 }}ms">
                    @if ($plan['popular'])
                        <div class="pricing-gradient-popular-ribbon">{{ $section['popular_badge'] }}</div>
                    @endif
                    <div class="pricing-gradient-card-header">
                        <h3 class="pricing-gradient-plan-name">{{ $plan['name'] }}</h3>
                        <p class="pricing-gradient-plan-desc">{{ $plan['description'] }}</p>
                    </div>
                    <div class="pricing-gradient-price-container">
                        <div class="pricing-gradient-price-wrapper">
                            <span class="pricing-gradient-currency">{{ $section['currency_symbol'] }}</span>
                            <span class="pricing-gradient-amount">{{ $plan['price'] }}</span>
                        </div>
                        <span class="pricing-gradient-period">/{{ $plan['period'] }}</span>
                    </div>
                    <ul class="pricing-gradient-features">
                        @foreach ($plan['features'] as $feature)
                            <li class="pricing-gradient-feature {{ $feature['is_included'] ? 'pricing-gradient-feature-included' : 'pricing-gradient-feature-excluded' }}">
                                <x-icon icon="{{ $feature['icon'] ?? 'lucide:check' }}" class="pricing-gradient-feature-icon" />
                                <span>{{ $feature['text'] }}</span>
                            </li>
                        @endforeach
                    </ul>
                    <a href="{{ $section['cta_button_url'] ?? '#contact' }}" class="pricing-gradient-btn">{{ $section['cta_button'] }}</a>
                </div>
            @endforeach
        </div>
    </div>
</section>

</div>