<?php
use Livewire\Component;
?>

<section id="faq" class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Header --}}
        <div class="text-center mb-16">
            <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
            <h2 class="section-title">{{ $section['title'] }}</h2>
            <p class="section-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- FAQ Accordion --}}
        <div class="space-y-0">
            @foreach ($items as $index => $faq)
                <div class="scroll-animate faq-item {{ $index === 0 ? 'active' : '' }}">
                    <div class="faq-question">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white pr-8">
                            {{ $faq['question'] }}</h3>
                        <x-icon icon="heroicons:chevron-down" class="faq-icon w-5 h-5 text-gray-500 flex-shrink-0" />
                    </div>
                    <div class="faq-answer">
                        <p class="text-gray-600 dark:text-gray-400">{{ $faq['answer'] }}</p>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>