<?php
use Livewire\Component;
?>

<div>
    <section class="hero3-section" @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Background Image --}}
        <div class="hero3-bg-image">
            <img src="{{ $hero['hero_image_url'] ?? ($hero['hero_image'] ?? 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600&h=500&fit=crop') }}"
                alt="Professional Laundry Service" loading="lazy">
        </div>

        {{-- Overlay --}}
        <div class="hero3-overlay"></div>

        {{-- Container --}}
        <div class="hero3-container">
            {{-- Main Content --}}
            <div class="hero3-content animate-fade-in-up">
                {{-- Badge --}}
                <div class="hero3-badge">
                    <span class="hero3-badge-dot"></span>
                    <span>{{ $hero['badge'] }}</span>
                </div>

                {{-- Title --}}
                <h1 class="hero3-title">
                    {{ $hero['title'] }}
                    <span class="hero3-subtitle">{{ $hero['subtitle'] }}</span>
                </h1>

                {{-- Description --}}
                <p class="hero3-description">{{ $hero['description'] }}</p>

                {{-- CTA Buttons --}}
                <div class="hero3-cta-group">
                    @foreach ($hero['buttons'] ?? [] as $index => $button)
                        @if ($button['is_transparent'] ?? false)
                            <a href="{{ $button['url'] ?? '#' }}" class="hero3-btn-secondary">
                                @if (!empty($button['icon']))
                                    <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                @endif
                                @if (!empty($button['text']))
                                    <span>{{ $button['text'] }}</span>
                                @endif
                            </a>
                        @else
                            <a href="{{ $button['url'] ?? '#' }}" class="hero3-btn-primary">
                                @if (!empty($button['icon']))
                                    <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                @endif
                                @if (!empty($button['text']))
                                    <span>{{ $button['text'] }}</span>
                                @endif
                            </a>
                        @endif
                    @endforeach
                </div>

                {{-- Stats --}}
                @if (!empty($hero['stats']))
                    <div class="hero3-stats">
                        @foreach ($hero['stats'] as $stat)
                            <div class="hero3-stat-item">
                                @if (!empty($stat['icon']))
                                    <div class="hero3-stat-icon">
                                        <x-icon icon="{{ $stat['icon'] }}" class="w-6 h-6" />
                                    </div>
                                @endif
                                <div class="hero3-stat-value">{{ $stat['value'] }}</div>
                                <div class="hero3-stat-label">{{ $stat['label'] }}</div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>

            {{-- Floating Cards --}}
            @foreach ($hero['floating_cards'] ?? [] as $index => $card)
                <div
                    class="{{ $index === 0 ? 'hero3-float-left' : 'hero3-float-right' }} animate-bounce-soft {{ $index > 0 ? 'delay-300' : '' }}">
                    <div class="hero3-float-card">
                        <div class="hero3-float-icon {{ $index === 0 ? 'green' : 'blue' }}">
                            <x-icon icon="{{ $card['icon'] ?? 'heroicons:check' }}" class="w-6 h-6 text-white" />
                        </div>
                        <div>
                            <p class="hero3-float-title">{{ $card['title'] ?? '' }}</p>
                            <p class="hero3-float-subtitle">{{ $card['subtitle'] ?? '' }}</p>
                        </div>
                    </div>
                </div>
            @endforeach

            {{-- Scroll Indicator --}}
            <div class="hero3-scroll-indicator">
                <div class="hero3-scroll-mouse">
                    <div class="hero3-scroll-wheel"></div>
                </div>
                <span>Scroll</span>
            </div>
        </div>
    </section>

    
</div>