<?php
use Livewire\Component;
?>

@php
    $textColorMode = $section['text_color_mode'] ?? 'auto';
    $textColorClass = match($textColorMode) {
        'light' => 'header2-text-light',
        'dark' => 'header2-text-dark',
        default => '',
    };
    $isSolidHeader = !($section['transparent'] ?? true);
@endphp
<div>
<!-- Floating Pill Header -->
<header id="header" class="header2-wrapper {{ $isSolidHeader ? 'header2-solid' : 'header2-transparent' }} {{ $textColorClass }}"
    data-transparent="{{ $isSolidHeader ? 'false' : 'true' }}"
    data-text-color-mode="{{ $textColorMode }}"
    data-solid="{{ $isSolidHeader ? 'true' : 'false' }}">
    <div class="header2-container">
        <div class="header2-pill">
            {{-- Logo with theme mode support based on header_logo_type setting --}}
            @php
                $headerLogoType = $company['header_logo_type'] ?? 'logo_with_name';
                $showName = in_array($headerLogoType, ['logo_with_name', 'light_dark_with_name']);
                $useFullLogo = in_array($headerLogoType, ['light_dark_with_name', 'light_dark_only']);
            @endphp
            <a href="{{ $homeUrl }}" wire:navigate class="header2-logo">
                @if ($useFullLogo)
                    {{-- Full Logo (Light/Dark based on theme) --}}
                    <img src="{{ $company['light_logo'] ?? asset('images/light.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="header2-logo-img dark:hidden" />
                    <img src="{{ $company['dark_logo'] ?? asset('images/dark.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="header2-logo-img hidden dark:block" />
                @else
                    {{-- Small Logo (Light/Dark based on theme) --}}
                    <img src="{{ $company['light_logo_small'] ?? asset('images/small_light.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="header2-logo-img dark:hidden" />
                    <img src="{{ $company['dark_logo_small'] ?? asset('images/small_dark.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="header2-logo-img hidden dark:block" />
                @endif

                @if ($showName && !empty($company['name']))
                    <span class="header2-logo-text">{{ $company['name'] }}</span>
                @endif
            </a>

            <!-- Desktop Navigation -->
            @php
                // Show max 3 items in pill header, rest go to More dropdown
                $maxVisibleItems = 3;
                $totalItems = count($navItems);
                $hasMoreItems = $totalItems > $maxVisibleItems;
            @endphp
            <nav class="header2-nav">
                @forelse ($navItems as $index => $item)
                    @if ($index < $maxVisibleItems)
                        <a href="{{ $item['url'] }}" wire:navigate class="header2-nav-link"
                            data-page="{{ $item['page_key'] }}">
                            {{ $item['name'] }}
                        </a>
                    @endif
                @empty
                    <a href="{{ $homeUrl }}#services" wire:navigate class="header2-nav-link"
                        data-section="services">
                        {{ $nav['services'] ?? 'Services' }}
                    </a>
                    <a href="{{ $homeUrl }}#how-it-works" wire:navigate class="header2-nav-link"
                        data-section="how-it-works">
                        {{ $nav['how_it_works'] ?? 'How It Works' }}
                    </a>
                    <a href="{{ $homeUrl }}#pricing" wire:navigate class="header2-nav-link"
                        data-section="pricing">
                        {{ $nav['pricing'] ?? 'Pricing' }}
                    </a>
                @endforelse

                {{-- More Dropdown for remaining items --}}
                @if ($hasMoreItems)
                    <div class="relative" x-data="{ open: false }">
                        <button @click="open = !open" @click.away="open = false"
                            class="header2-nav-link flex items-center gap-1">
                            {{ $section['more_text'] ?? 'More' }}
                            <svg class="w-3.5 h-3.5 transition-transform duration-200" :class="{ 'rotate-180': open }"
                                fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                        <div x-show="open"
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 translate-y-2"
                            x-transition:enter-end="opacity-100 translate-y-0"
                            x-transition:leave="transition ease-in duration-150"
                            x-transition:leave-start="opacity-100 translate-y-0"
                            x-transition:leave-end="opacity-0 translate-y-2"
                            class="header2-more-dropdown absolute top-full left-0 mt-2 min-w-[200px] rounded-lg shadow-lg bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 z-50 py-1.5 overflow-hidden"
                            style="display: none;">
                            @foreach ($navItems as $index => $item)
                                @if ($index >= $maxVisibleItems)
                                    <a href="{{ $item['url'] }}" wire:navigate
                                        data-page="{{ $item['page_key'] }}"
                                        class="header2-more-item group flex items-center justify-between gap-2 px-4 py-2.5 text-sm text-gray-600 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700/50 hover:text-primary-600 dark:hover:text-primary-400 transition-colors duration-150">
                                        <span>{{ $item['name'] }}</span>
                                        <svg class="w-3.5 h-3.5 opacity-0 -translate-x-1 group-hover:opacity-100 group-hover:translate-x-0 transition-all duration-150 text-primary-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                        </svg>
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif
            </nav>

            <!-- Right Actions -->
            <div class="header2-actions">
                <!-- Language Selector (Desktop) -->
                @if (!empty($languages) && count($languages) > 1)
                    <div class="header2-lang-wrapper hidden lg:block" x-data="{ open: false }">
                        <button @click="open = !open" @click.away="open = false" class="header2-lang-btn"
                            aria-label="Language selector">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 5h12M9 3v2m1.048 9.5A18.022 18.022 0 016.412 9m6.088 9h7M11 21l5-10 5 10M12.751 5C11.783 10.77 8.07 15.61 3 18.129">
                                </path>
                            </svg>
                            <span class="header2-lang-text">
                                {{ strtoupper($languages[$currentLangKey]['short_name'] ?? $currentLangKey) }}
                            </span>
                        </button>

                        <div x-show="open" x-transition class="header2-lang-dropdown">
                            @foreach ($languages as $lang)
                                <button wire:click="changeLanguage('{{ $lang['key'] }}')"
                                    class="header2-lang-option {{ $lang['key'] === $currentLangKey ? 'active' : '' }}">
                                    <div class="flex items-center gap-2">
                                        @if (!empty($lang['flag_emoji']))
                                            <span class="text-base">{{ $lang['flag_emoji'] }}</span>
                                        @endif
                                        <span>{{ $lang['name'] }}</span>
                                    </div>
                                    @if ($lang['key'] === $currentLangKey)
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M5 13l4 4L19 7"></path>
                                        </svg>
                                    @endif
                                </button>
                            @endforeach
                        </div>
                    </div>
                @endif

                <!-- Theme Toggle (Desktop) - Hidden for now, only light mode supported
                <button id="theme-toggle" class="header2-theme-toggle hidden lg:flex" aria-label="Toggle theme">
                    <svg class="w-5 h-5 sun-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z">
                        </path>
                    </svg>
                    <svg class="w-5 h-5 moon-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z">
                        </path>
                    </svg>
                </button>
                -->

                <!-- CTA Buttons (Desktop) -->
                @if (!empty($section['cta_buttons']) && is_array($section['cta_buttons']))
                    @foreach ($section['cta_buttons'] as $btnIndex => $ctaBtn)
                        @if (is_array($ctaBtn) && (!empty($ctaBtn['text']) || !empty($ctaBtn['icon'])))
                            <a href="{{ $ctaBtn['url'] ?? '#contact' }}"
                                @if (str_starts_with($ctaBtn['url'] ?? '#contact', '#')) wire:navigate data-section="{{ ltrim($ctaBtn['url'] ?? '#contact', '#') }}" @endif
                                class="header2-cta-btn hidden lg:flex">
                                @if (!empty($ctaBtn['icon']))<x-icon :icon="$ctaBtn['icon']" class="w-5 h-5" />@endif
                                @if (!empty($ctaBtn['text']))<span>{{ $ctaBtn['text'] }}</span>@endif
                            </a>
                        @endif
                    @endforeach
                @endif

                <!-- Mobile: Menu Button -->
                <button id="mobile-menu-btn" class="header2-mobile-btn lg:hidden" aria-label="Open menu">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                </button>
            </div>
        </div>
    </div>
</header>

<!-- Mobile Menu Overlay -->
<div id="mobile-menu-overlay" class="header2-overlay"></div>

<!-- Mobile Menu -->
<div id="mobile-menu" class="header2-mobile-menu">
    <!-- Mobile Menu Header -->
    <div class="header2-mobile-header">
        <div class="flex items-center gap-3">
            @if ($useFullLogo)
                <img src="{{ $company['light_logo'] ?? asset('images/light.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                    class="h-10 w-auto dark:hidden" />
                <img src="{{ $company['dark_logo'] ?? asset('images/dark.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                    class="h-10 w-auto hidden dark:block" />
            @else
                <img src="{{ $company['light_logo_small'] ?? asset('images/small_light.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                    class="h-10 w-auto dark:hidden" />
                <img src="{{ $company['dark_logo_small'] ?? asset('images/small_dark.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                    class="h-10 w-auto hidden dark:block" />
            @endif
            @if ($showName && !empty($company['name']))
                <span class="font-bold text-lg">{{ $company['name'] }}</span>
            @endif
        </div>
        <button id="mobile-menu-close" class="header2-mobile-close" aria-label="Close menu">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                </path>
            </svg>
        </button>
    </div>

    <!-- Mobile Navigation -->
    <nav class="flex-1 overflow-y-auto">
        @forelse ($navItems as $item)
            <a href="{{ $item['url'] }}" wire:navigate
                class="header2-mobile-link mobile-menu-link" data-page="{{ $item['page_key'] }}">
                <span>{{ $item['name'] }}</span>
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
            </a>
        @empty
            <a href="{{ $homeUrl }}#services" wire:navigate class="header2-mobile-link mobile-menu-link"
                data-section="services">
                <span>{{ $nav['services'] ?? 'Services' }}</span>
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
            </a>
            <a href="{{ $homeUrl }}#how-it-works" wire:navigate class="header2-mobile-link mobile-menu-link"
                data-section="how-it-works">
                <span>{{ $nav['how_it_works'] ?? 'How It Works' }}</span>
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
            </a>
            <a href="{{ $homeUrl }}#pricing" wire:navigate class="header2-mobile-link mobile-menu-link"
                data-section="pricing">
                <span>{{ $nav['pricing'] ?? 'Pricing' }}</span>
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
            </a>
            <a href="{{ $homeUrl }}#testimonials" wire:navigate class="header2-mobile-link mobile-menu-link"
                data-section="testimonials">
                <span>{{ $nav['reviews'] ?? 'Reviews' }}</span>
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
            </a>
            <a href="{{ $homeUrl }}#faq" wire:navigate class="header2-mobile-link mobile-menu-link"
                data-section="faq">
                <span>{{ $nav['faq'] ?? 'FAQ' }}</span>
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
            </a>
            <a href="{{ $homeUrl }}#contact" wire:navigate class="header2-mobile-link mobile-menu-link"
                data-section="contact">
                <span>{{ $nav['contact'] ?? 'Contact' }}</span>
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
            </a>
        @endforelse
    </nav>

    <!-- Mobile Menu Footer -->
    <div class="header2-mobile-footer">
        <div class="flex items-center justify-between mb-4">
            <!-- Theme Toggle Mobile - Hidden for now, only light mode supported
            <button id="theme-toggle-mobile" class="header2-theme-toggle-mobile" aria-label="Toggle theme">
                <svg class="w-5 h-5 sun-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z">
                    </path>
                </svg>
                <svg class="w-5 h-5 moon-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z">
                    </path>
                </svg>
            </button>
            -->

            <!-- Language Selector Mobile -->
            @if (!empty($languages) && count($languages) > 1)
                <div class="header2-lang-wrapper" x-data="{ open: false }">
                    <button @click="open = !open" @click.away="open = false" class="header2-lang-btn-mobile">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3 5h12M9 3v2m1.048 9.5A18.022 18.022 0 016.412 9m6.088 9h7M11 21l5-10 5 10M12.751 5C11.783 10.77 8.07 15.61 3 18.129">
                            </path>
                        </svg>
                        <span>{{ strtoupper($languages[$currentLangKey]['short_name'] ?? $currentLangKey) }}</span>
                    </button>

                    <div x-show="open" x-transition class="header2-lang-dropdown">
                        @foreach ($languages as $lang)
                            <button wire:click="changeLanguage('{{ $lang['key'] }}')"
                                class="header2-lang-option {{ $lang['key'] === $currentLangKey ? 'active' : '' }}">
                                <div class="flex items-center gap-2">
                                    @if (!empty($lang['flag_emoji']))
                                        <span class="text-base">{{ $lang['flag_emoji'] }}</span>
                                    @endif
                                    <span>{{ $lang['name'] }}</span>
                                </div>
                                @if ($lang['key'] === $currentLangKey)
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M5 13l4 4L19 7"></path>
                                    </svg>
                                @endif
                            </button>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>

        <!-- CTA Buttons Mobile -->
        @if (!empty($section['cta_buttons']) && is_array($section['cta_buttons']))
            <div class="space-y-2">
                @foreach ($section['cta_buttons'] as $btnIndex => $ctaBtn)
                    @if (is_array($ctaBtn) && (!empty($ctaBtn['text']) || !empty($ctaBtn['icon'])))
                        <a href="{{ $ctaBtn['url'] ?? '#contact' }}"
                            @if (str_starts_with($ctaBtn['url'] ?? '#contact', '#')) data-section="{{ ltrim($ctaBtn['url'] ?? '#contact', '#') }}" @endif
                            class="header2-mobile-cta mobile-menu-link flex items-center justify-center gap-2">
                            @if (!empty($ctaBtn['icon']))<x-icon :icon="$ctaBtn['icon']" class="w-5 h-5" />@endif
                            @if (!empty($ctaBtn['text']))<span>{{ $ctaBtn['text'] }}</span>@endif
                        </a>
                    @endif
                @endforeach
            </div>
        @endif
    </div>
</div>
</div>



@script
    <script>
        // Make closeMobileMenu globally accessible
        window.closeMobileMenu = function() {
            const mobileMenu = document.getElementById('mobile-menu');
            const overlay = document.getElementById('mobile-menu-overlay');

            if (mobileMenu) {
                mobileMenu.classList.remove('active');
            }
            if (overlay) {
                overlay.classList.remove('active');
                // Immediately hide overlay completely to prevent blur
                overlay.style.visibility = 'hidden';
                overlay.style.opacity = '0';
                overlay.style.pointerEvents = 'none';
                overlay.style.backdropFilter = 'none';
                overlay.style.webkitBackdropFilter = 'none';
                overlay.style.background = 'transparent';
            }
            // Always restore body scroll
            document.body.style.overflow = '';
        };

        // Mobile menu toggle
        const menuBtn = document.getElementById('mobile-menu-btn');
        const closeBtn = document.getElementById('mobile-menu-close');
        const mobileMenu = document.getElementById('mobile-menu');
        const overlay = document.getElementById('mobile-menu-overlay');

        if (menuBtn && mobileMenu && overlay) {
            menuBtn.addEventListener('click', () => {
                mobileMenu.classList.add('active');
                overlay.classList.add('active');
                // Reset inline styles when opening
                overlay.style.visibility = '';
                overlay.style.opacity = '';
                overlay.style.pointerEvents = '';
                overlay.style.backdropFilter = '';
                overlay.style.webkitBackdropFilter = '';
                overlay.style.background = '';
                document.body.style.overflow = 'hidden';
            });
        }

        if (closeBtn) {
            closeBtn.addEventListener('click', window.closeMobileMenu);
        }

        if (overlay) {
            overlay.addEventListener('click', window.closeMobileMenu);
        }

        // Close menu when clicking on mobile menu links
        const mobileMenuLinks = document.querySelectorAll('.mobile-menu-link');
        mobileMenuLinks.forEach(link => {
            link.addEventListener('click', (e) => {
                // Always close menu immediately
                window.closeMobileMenu();
            });
        });

        // Reload page after language change
        // Remove 'lang' query parameter if present before reload
        $wire.on('language-changed', () => {
            const url = new URL(window.location.href);
            if (url.searchParams.has('lang')) {
                url.searchParams.delete('lang');
                window.location.href = url.toString();
            } else {
                window.location.reload();
            }
        });
    </script>
@endscript

</div>