<?php
use Livewire\Component;
?>

<section class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Header --}}
        <div class="text-center mb-16">
            <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
            <h2 class="section-title">{{ $section['title'] }}</h2>
            <p class="section-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Gallery Grid --}}
        <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
            @foreach ($items as $index => $item)
                <div class="scroll-animate gallery-item {{ $index === 0 ? 'md:col-span-2 md:row-span-2' : '' }}">
                    <img src="{{ $item['image_url'] ?? $item['image'] }}" alt="{{ $item['alt'] }}"
                        class="w-full h-full object-cover {{ $index === 0 ? 'aspect-square md:aspect-auto md:h-full' : 'aspect-square' }}"
                        loading="lazy">
                    <div class="gallery-overlay">
                        <p class="text-white font-medium">{{ $item['alt'] }}</p>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>