<?php
use Livewire\Component;
?>

<div>
<section id="services" class="services-gradient-section" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    {{-- Background --}}
    <div class="services-gradient-bg">
        <div class="services-gradient-mesh"></div>
        <div class="services-gradient-orb services-gradient-orb-1"></div>
        <div class="services-gradient-orb services-gradient-orb-2"></div>
        <div class="services-gradient-orb services-gradient-orb-3"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        {{-- Section Header --}}
        <div class="services-gradient-header">
            <div class="services-gradient-badge">
                <span class="services-gradient-badge-dot"></span>
                {{ $section['badge'] }}
            </div>
            <h2 class="services-gradient-title">{{ $section['title'] }}</h2>
            <p class="services-gradient-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Services Grid --}}
        <div class="services-gradient-grid">
            @foreach ($items as $index => $item)
                <div class="services-gradient-card scroll-animate" style="animation-delay: {{ $index * 100 }}ms">
                    {{-- Gradient Border --}}
                    <div class="services-gradient-card-border"></div>

                    {{-- Card Inner --}}
                    <div class="services-gradient-card-inner">
                        {{-- Top Section with Icon --}}
                        <div class="services-gradient-top">
                            <div class="services-gradient-icon">
                                <x-icon icon="{{ $item['icon'] ?? 'heroicons:sparkles' }}" class="w-7 h-7" />
                            </div>
                            @if (!empty($item['price']))
                                <div class="services-gradient-price">{{ $item['price'] }}</div>
                            @endif
                        </div>

                        {{-- Content --}}
                        <div class="services-gradient-content">
                            <h3 class="services-gradient-card-title">{{ $item['title'] ?? '' }}</h3>
                            <p class="services-gradient-desc">{{ $item['description'] ?? '' }}</p>
                        </div>

                        {{-- Features --}}
                        @if (!empty($item['features']))
                            <div class="services-gradient-features">
                                @foreach ($item['features'] as $feature)
                                    <div class="services-gradient-feature">
                                        <div class="services-gradient-feature-check">
                                            <x-icon icon="lucide:check" class="w-3 h-3" />
                                        </div>
                                        <span>{{ is_array($feature) ? ($feature['text'] ?? '') : $feature }}</span>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        {{-- Button --}}
                        @if (!empty($item['button_text']) && !empty($item['button_url']))
                            <a href="{{ $item['button_url'] }}" class="services-gradient-btn">
                                <span>{{ $item['button_text'] }}</span>
                                <x-icon icon="{{ $item['button_icon'] ?? 'lucide:arrow-right' }}" class="w-4 h-4" />
                            </a>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>


</div>