<?php
use Livewire\Component;
use App\Models\Website;
use App\Models\WebsiteLegalPage;
use App\Models\WebsiteLanguage;
?>

<div>
<footer class="bg-gray-900 text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        @php
            $linkGroups = $footer['link_groups'] ?? [];
            $headerLogoType = $company['header_logo_type'] ?? 'logo_with_name';
            $showName = in_array($headerLogoType, ['logo_with_name', 'light_dark_with_name']);
            $useFullLogo = in_array($headerLogoType, ['light_dark_with_name', 'light_dark_only']);
        @endphp

        {{-- Row 1: Company Info, Dynamic Link Groups, and Contact Info --}}
        @php
            // Limit to first 3 link groups
            $displayLinkGroups = array_slice($linkGroups, 0, 3);
            // Total sections: 1 (Company Info) + link groups + 1 (Contact Info)
            $totalSections = 2 + count($displayLinkGroups);

            // Calculate column spans to distribute evenly across 5 columns
            // If we have 4 sections total: each gets floor(5/4) = 1, with 1 leftover
            // If we have 5 sections total: each gets 1
            $baseSpan = floor(5 / $totalSections);
            $remainder = 5 % $totalSections;

            // Distribute remainder: first section (Company) and last section (Contact) get extra
            $companySpan = $baseSpan + ($remainder > 0 ? 1 : 0);
            $contactSpan = $baseSpan + ($remainder > 1 ? 1 : 0);
            $linkGroupSpan = $baseSpan;
        @endphp
        <div class="py-12">
            {{-- Responsive grid:
                 Mobile (< 640px): 1 column - everything stacks
                 Small (640-767px): 2 columns
                 Medium (768-1023px): 3 columns
                 Large (>= 1024px): 5 columns with equal distribution --}}
            <div
                class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-5 gap-8">
                {{-- Company Info --}}
                <div class="sm:col-span-2 md:col-span-1 lg:col-span-{{ $companySpan }}">
                    <div class="flex items-center gap-2 mb-6">
                        {{-- Footer is always on dark background, so use dark variants --}}
                        @if ($useFullLogo)
                            <img src="{{ $company['dark_logo'] ?? asset('images/dark.png') }}"
                                alt="{{ $company['name'] ?? 'Logo' }}" class="h-10 w-auto" />
                        @else
                            <img src="{{ $company['dark_logo_small'] ?? asset('images/small_dark.png') }}"
                                alt="{{ $company['name'] ?? 'Logo' }}" class="h-10 w-auto" />
                        @endif
                        @if ($showName)
                            <span class="text-xl font-bold">{{ $company['name'] ?? 'Washville' }}</span>
                        @endif
                    </div>
                    @if (!empty($company['description']))
                        <p class="text-gray-400 mb-6">{{ $company['description'] }}</p>
                    @elseif (!empty($company['tagline']) || !empty($footer['description']))
                        <p class="text-gray-400 mb-6">
                            {{ $company['tagline'] ?? '' }}{{ !empty($company['tagline']) && !empty($footer['description']) ? '. ' : '' }}{{ $footer['description'] ?? '' }}
                        </p>
                    @endif
                    @if (($social['show_icon'] ?? true) && count($social ?? []) > 0)
                        <div class="flex gap-4">
                            @foreach ($social ?? [] as $socialIndex => $link)
                                @if (is_array($link))
                                    <a wire:key="social-{{ $socialIndex }}" href="{{ $link['url'] ?? '#' }}"
                                        class="w-10 h-10 rounded-full bg-gray-800 flex items-center justify-center hover:bg-primary-600 transition-colors">
                                        <x-icon icon="{{ $link['icon'] ?? 'mdi:link' }}" class="w-5 h-5" />
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    @endif
                </div>

                {{-- Dynamic Link Groups from footer settings --}}
                @if (!empty($displayLinkGroups) && is_array($displayLinkGroups))
                    @foreach ($displayLinkGroups as $groupIndex => $group)
                        @if (is_array($group) && !empty($group['title']))
                            <div wire:key="link-group-{{ $groupIndex }}">
                                <h3 class="text-lg font-semibold mb-6">{{ $group['title'] }}</h3>
                                @if (!empty($group['links']) && is_array($group['links']))
                                    <ul class="space-y-3">
                                        @foreach ($group['links'] as $linkIndex => $link)
                                            @if (is_array($link) && !empty($link['title']))
                                                <li
                                                    wire:key="link-group-{{ $groupIndex }}-link-{{ $linkIndex }}">
                                                    <a href="{{ $link['url'] ?? '#' }}"
                                                        @if (str_starts_with($link['url'] ?? '', '#')) wire:navigate data-section="{{ ltrim($link['url'] ?? '', '#') }}" @endif
                                                        class="text-gray-400 hover:text-white transition-colors">{{ $link['title'] }}</a>
                                                </li>
                                            @endif
                                        @endforeach
                                    </ul>
                                @endif
                            </div>
                        @endif
                    @endforeach
                @endif

                {{-- Contact Info --}}
                <div class="lg:col-span-{{ $contactSpan }}">
                    <h3 class="text-lg font-semibold mb-6">{{ $footer['contact_title'] ?? 'Contact Us' }}</h3>
                    <ul class="space-y-3">
                        <li class="flex items-start gap-3">
                            <x-icon icon="heroicons:map-pin" class="w-5 h-5 text-primary-400 mt-1 flex-shrink-0" />
                            <span class="text-gray-400">{{ $company['address'] ?? '' }}</span>
                        </li>
                        <li class="flex items-center gap-3">
                            <x-icon icon="heroicons:phone" class="w-5 h-5 text-primary-400 flex-shrink-0" />
                            <a href="tel:{{ $company['phone'] ?? '' }}"
                                class="text-gray-400 hover:text-white transition-colors">{{ $company['phone'] ?? '' }}</a>
                        </li>
                        <li class="flex items-center gap-3">
                            <x-icon icon="heroicons:envelope" class="w-5 h-5 text-primary-400 flex-shrink-0" />
                            <a href="mailto:{{ $company['email'] ?? '' }}"
                                class="text-gray-400 hover:text-white transition-colors">{{ $company['email'] ?? '' }}</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        {{-- Footer Bottom --}}
        <div class="py-8 border-t border-gray-800 flex flex-col md:flex-row justify-between items-center">
            <p class="text-gray-400 text-sm">{!! str_replace(
                ['%year%', '%business%'],
                [date('Y'), $company['name'] ?? 'Washville'],
                $footer['copyright'] ?? '&copy; %year% %business%. All rights reserved.',
            ) !!}</p>
            <div class="flex gap-6 mt-4 md:mt-0">
                @foreach ($pages as $page)
                    <a wire:key="page-{{ $page->id }}"
                        href="{{ landing_page_url($page->slug, view()->shared('frontWebsite'), $websiteSlug) }}"
                        wire:navigate
                        class="text-gray-400 hover:text-white text-sm transition-colors">{{ $page->title }}</a>
                @endforeach
            </div>
        </div>
    </div>
</footer>


</div>