<?php
use Livewire\Component;
?>

<div>
<section class="features-grid-section {{ $isWhiteBackground ? 'features-grid-white' : 'features-grid-gray' }}" @if($this->getPaddingStyle()) style="{{ $this->getPaddingStyle() }}" @endif>
    {{-- Background Pattern --}}
    <div class="features-grid-pattern"></div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        <div class="features-grid-container">
            @foreach ($items as $index => $feature)
                <div class="features-grid-item scroll-animate" style="animation-delay: {{ $index * 100 }}ms">
                    {{-- Number Badge --}}
                    <div class="features-grid-number">{{ str_pad($index + 1, 2, '0', STR_PAD_LEFT) }}</div>

                    {{-- Icon with Pulse Effect --}}
                    <div class="features-grid-icon-container">
                        <div class="features-grid-pulse"></div>
                        <div class="features-grid-icon">
                            <x-icon icon="{{ $feature['icon'] ?? 'heroicons:heart' }}" class="w-6 h-6" />
                        </div>
                    </div>

                    {{-- Content --}}
                    <div class="features-grid-content">
                        <h3 class="features-grid-title">{{ $feature['title'] }}</h3>
                        <p class="features-grid-desc">{{ $feature['description'] }}</p>
                    </div>

                    {{-- Hover Border --}}
                    <div class="features-grid-border"></div>
                </div>
            @endforeach
        </div>
    </div>
</section>


</div>