<?php
use Livewire\Component;
?>

<div>
<section id="partners" class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Header --}}
        <div class="text-center mb-16">
            <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
            <h2 class="section-title">{{ $section['title'] }}</h2>
            <p class="section-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Partners Logos - Infinite Scroll --}}
        @if(count($items) > 0)
        <div class="relative overflow-hidden scroll-animate" data-animation="fade-up">
            <div class="partners-track flex items-center gap-16" style="width: max-content;">
                {{-- First set of logos --}}
                @foreach($items as $partner)
                <div class="partner-logo {{ ($section['grayscale'] ?? false) ? 'grayscale-mode' : '' }} flex-shrink-0 px-4 {{ ($section['show_title'] ?? false) ? 'flex flex-col items-center' : 'h-12' }}">
                    @if(!empty($partner['logo_url']) || !empty($partner['logo']))
                    <img src="{{ $partner['logo_url'] ?? $partner['logo'] }}" alt="{{ $partner['name'] ?? '' }}" class="{{ ($section['show_title'] ?? false) ? 'h-12' : 'h-full' }} w-auto object-contain">
                    @if(($section['show_title'] ?? false) && !empty($partner['name']))
                    <span class="partner-title whitespace-nowrap">{{ $partner['name'] }}</span>
                    @endif
                    @elseif(!empty($partner['name']))
                    <span class="text-2xl font-bold text-gray-400 dark:text-gray-500 whitespace-nowrap">{{ $partner['name'] }}</span>
                    @endif
                </div>
                @endforeach
                {{-- Duplicate for seamless loop --}}
                @foreach($items as $partner)
                <div class="partner-logo {{ ($section['grayscale'] ?? false) ? 'grayscale-mode' : '' }} flex-shrink-0 px-4 {{ ($section['show_title'] ?? false) ? 'flex flex-col items-center' : 'h-12' }}">
                    @if(!empty($partner['logo_url']) || !empty($partner['logo']))
                    <img src="{{ $partner['logo_url'] ?? $partner['logo'] }}" alt="{{ $partner['name'] ?? '' }}" class="{{ ($section['show_title'] ?? false) ? 'h-12' : 'h-full' }} w-auto object-contain">
                    @if(($section['show_title'] ?? false) && !empty($partner['name']))
                    <span class="partner-title whitespace-nowrap">{{ $partner['name'] }}</span>
                    @endif
                    @elseif(!empty($partner['name']))
                    <span class="text-2xl font-bold text-gray-400 dark:text-gray-500 whitespace-nowrap">{{ $partner['name'] }}</span>
                    @endif
                </div>
                @endforeach
            </div>
        </div>

        {{-- Static Grid (shown below infinite scroll) --}}
        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-8 items-center mt-12">
            @foreach($items as $index => $partner)
            <div class="partner-logo {{ ($section['grayscale'] ?? false) ? 'grayscale-mode' : '' }} flex flex-col items-center justify-center {{ ($section['show_title'] ?? false) ? 'h-auto py-4' : 'h-20' }} p-4 bg-white dark:bg-gray-800 rounded-xl shadow-lg border border-gray-100 dark:border-gray-700 scroll-animate" data-animation="fade-up" style="animation-delay: {{ $index * 100 }}ms">
                @if(!empty($partner['logo_url']) || !empty($partner['logo']))
                <img src="{{ $partner['logo_url'] ?? $partner['logo'] }}" alt="{{ $partner['name'] ?? '' }}" class="max-h-full max-w-full object-contain {{ ($section['show_title'] ?? false) ? 'h-16' : '' }}">
                @if(($section['show_title'] ?? false) && !empty($partner['name']))
                <span class="partner-title">{{ $partner['name'] }}</span>
                @endif
                @elseif(!empty($partner['name']))
                <span class="text-lg font-bold text-gray-400 dark:text-gray-500">{{ $partner['name'] }}</span>
                @endif
            </div>
            @endforeach
        </div>
        @endif
    </div>
</section>


</div>