<?php
use Livewire\Component;
?>

<div>
    


    <section class="section relative promo-split-bg"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Split Shapes --}}
        <div class="promo-split-shapes">
            <div class="promo-split-wave promo-split-wave-1"></div>
            <div class="promo-split-wave promo-split-wave-2"></div>
            <div class="promo-split-diagonal"></div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20">
            <div class="promo-split-container">
                {{-- Content Side --}}
                <div class="promo-split-content">
                    {{-- Badge --}}
                    <div class="promo-split-badge">
                        <x-icon icon="{{ $section['icon'] }}" class="w-4 h-4" />
                        <span>{{ $section['discount_value'] ?? '50%' }} {{ $section['discount_label'] ?? 'OFF' }} -
                            Limited Time!</span>
                    </div>

                    {{-- Headline --}}
                    <h2 class="promo-split-headline">{{ $section['headline'] }}</h2>

                    {{-- Description --}}
                    <p class="promo-split-description">{{ $section['description'] }}</p>

                    {{-- CTA Button --}}
                    <a href="{{ $section['cta_url'] }}" class="promo-split-cta">
                        <span>{{ $section['cta_text'] }}</span>
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M13 7l5 5m0 0l-5 5m5-5H6" />
                        </svg>
                    </a>

                    {{-- Terms --}}
                    @if (!empty($section['terms']))
                        <p class="promo-split-terms">{{ $section['terms'] }}</p>
                    @endif
                </div>

                {{-- Visual Side --}}
                <div class="promo-split-visual">
                    <div class="promo-split-visual-wrapper">
                        {{-- Decorative Rings --}}
                        <div class="promo-split-ring promo-split-ring-3"></div>
                        <div class="promo-split-ring promo-split-ring-2"></div>
                        <div class="promo-split-ring promo-split-ring-1"></div>

                        {{-- Main Visual Card --}}
                        <div class="promo-split-visual-card">
                            {{-- Sparkle decorations --}}
                            <div class="promo-split-sparkle promo-split-sparkle-1"></div>
                            <div class="promo-split-sparkle promo-split-sparkle-2"></div>
                            <div class="promo-split-sparkle promo-split-sparkle-3"></div>
                            <div class="promo-split-sparkle promo-split-sparkle-4"></div>

                            {{-- Discount Display --}}
                            <div class="promo-split-discount">
                                {{-- Icon --}}
                                <div class="promo-split-visual-icon">
                                    <svg class="w-12 h-12 mx-auto" fill="none" stroke="currentColor" stroke-width="2"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M19 5L5 19M6.5 9a2.5 2.5 0 100-5 2.5 2.5 0 000 5zM17.5 20a2.5 2.5 0 100-5 2.5 2.5 0 000 5z" />
                                    </svg>
                                </div>

                                {{-- Large Percentage --}}
                                <div class="promo-split-visual-percent">{{ $section['discount_value'] ?? '50%' }}</div>
                                <div class="promo-split-visual-label">{{ $section['discount_label'] ?? 'OFF' }}</div>
                            </div>

                            {{-- Countdown Timer --}}
                            @if ($section['show_countdown'] && !empty($section['expiry_date']))
                                <div class="promo-split-countdown" data-countdown-timer
                                    data-expiry="{{ $section['expiry_date'] }}">
                                    <div class="promo-split-countdown-item">
                                        <div class="promo-split-countdown-value" data-countdown-days>00</div>
                                        <div class="promo-split-countdown-label">
                                            {{ $section['countdown_days_label'] ?? 'Days' }}</div>
                                    </div>
                                    <div class="promo-split-countdown-item">
                                        <div class="promo-split-countdown-value" data-countdown-hours>00</div>
                                        <div class="promo-split-countdown-label">
                                            {{ $section['countdown_hours_label'] ?? 'Hrs' }}</div>
                                    </div>
                                    <div class="promo-split-countdown-item">
                                        <div class="promo-split-countdown-value" data-countdown-minutes>00</div>
                                        <div class="promo-split-countdown-label">
                                            {{ $section['countdown_minutes_label'] ?? 'Mins' }}</div>
                                    </div>
                                    <div class="promo-split-countdown-item">
                                        <div class="promo-split-countdown-value" data-countdown-seconds>00</div>
                                        <div class="promo-split-countdown-label">
                                            {{ $section['countdown_seconds_label'] ?? 'Secs' }}</div>
                                    </div>
                                </div>
                            @endif

                            {{-- Promo Code --}}
                            @if ($section['show_promo_code'] && !empty($section['promo_code']))
                                <div class="promo-split-visual-code">
                                    <div class="promo-split-code-label">Use Code</div>
                                    <div class="promo-split-visual-code-box" x-data="{ copied: false }"
                                        @click="navigator.clipboard.writeText('{{ $section['promo_code'] }}'); copied = true; setTimeout(() => copied = false, 2000)">
                                        <span class="promo-split-visual-code-text">{{ $section['promo_code'] }}</span>
                                        <svg class="w-5 h-5 promo-split-code-copy-icon" x-show="!copied" fill="none"
                                            stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z" />
                                        </svg>
                                        <svg class="w-5 h-5 text-green-600" x-show="copied" x-cloak fill="none"
                                            stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
                                        </svg>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    @if (($section['show_countdown'] ?? false) && !empty($section['expiry_date']))
        @script
            <script>
                (function() {
                    const timers = document.querySelectorAll('[data-countdown-timer]');

                    timers.forEach(function(wrapper) {
                        if (wrapper.dataset.countdownInitialized) return;
                        wrapper.dataset.countdownInitialized = 'true';

                        const endDateStr = (wrapper.getAttribute('data-expiry') || '').replace(' ', 'T');
                        if (!endDateStr) return;

                        const daysEl = wrapper.querySelector('[data-countdown-days]');
                        const hoursEl = wrapper.querySelector('[data-countdown-hours]');
                        const minutesEl = wrapper.querySelector('[data-countdown-minutes]');
                        const secondsEl = wrapper.querySelector('[data-countdown-seconds]');

                        if (!daysEl || !hoursEl || !minutesEl || !secondsEl) return;

                        function updateCountdown() {
                            const end = new Date(endDateStr).getTime();
                            const now = new Date().getTime();
                            const diff = end - now;

                            if (diff > 0) {
                                daysEl.textContent = String(Math.floor(diff / (1000 * 60 * 60 * 24))).padStart(2, '0');
                                hoursEl.textContent = String(Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 *
                                    60))).padStart(2, '0');
                                minutesEl.textContent = String(Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60)))
                                    .padStart(2, '0');
                                secondsEl.textContent = String(Math.floor((diff % (1000 * 60)) / 1000)).padStart(2,
                                    '0');
                            } else {
                                wrapper.style.display = 'none';
                            }
                        }

                        updateCountdown();
                        setInterval(updateCountdown, 1000);
                    });
                })();
            </script>
        @endscript
    @endif

</div>