<?php
use Livewire\Component;
?>

<section id="stats" class="py-16 {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            @if($section['badge'])
                <span class="inline-block px-4 py-1 rounded-full text-sm font-semibold bg-primary-100 text-primary-700 dark:bg-primary-900 dark:text-primary-300 mb-4">
                    {{ $section['badge'] }}
                </span>
            @endif

            <h2 class="text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                {{ $section['title'] }}
            </h2>

            <p class="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
                {{ $section['subtitle'] }}
            </p>
        </div>

        <div class="grid grid-cols-2 md:grid-cols-4 gap-8">
            @foreach($items as $stat)
                <div class="text-center p-6 rounded-xl bg-gray-50 dark:bg-gray-800 hover:shadow-lg transition-shadow">
                    <div class="inline-flex items-center justify-center w-12 h-12 rounded-full bg-primary-100 dark:bg-primary-900 text-primary-600 dark:text-primary-400 mb-4">
                        <x-icon icon="{{ $stat['icon'] ?? 'heroicons:star' }}" class="w-6 h-6" />
                    </div>
                    <div class="text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white mb-2">
                        {{ $stat['value'] }}
                    </div>
                    <div class="text-gray-600 dark:text-gray-400">
                        {{ $stat['label'] }}
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>