<?php
use Livewire\Component;
?>

@php
    $textColorMode = $section['text_color_mode'] ?? 'auto';
    $textColorClass = match($textColorMode) {
        'light' => 'header3-text-light',
        'dark' => 'header3-text-dark',
        default => '',
    };
    $isSolidHeader = !($section['transparent'] ?? true);
@endphp
<div>
{{-- Header Style 3: Split Layout with Contact Bar --}}
<div id="header" class="{{ $section['sticky'] ?? true ? 'fixed' : 'relative' }} top-0 left-0 right-0 z-50 transition-all duration-300 {{ $isSolidHeader ? 'header3-solid' : 'header3-transparent' }} {{ $textColorClass }}"
    data-transparent="{{ $isSolidHeader ? 'false' : 'true' }}"
    data-text-color-mode="{{ $textColorMode }}"
    data-solid="{{ $isSolidHeader ? 'true' : 'false' }}">
    {{-- Contact Info Bar --}}
    <div class="header3-contact-bar">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-12 text-sm">
                {{-- Left: Address --}}
                <div class="flex items-center gap-6">
                    @if (!empty($company['address']))
                        <div class="hidden sm:flex items-center gap-2 header3-welcome">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z">
                                </path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                            <span>{{ $company['address'] }}</span>
                        </div>
                    @endif
                </div>

                {{-- Right: Contact & Social --}}
                <div class="flex items-center gap-4">
                    @if (!empty($company['phone']))
                        <a href="tel:{{ $company['phone'] }}" class="header3-contact-link flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                                </path>
                            </svg>
                            <span class="hidden md:inline">{{ $company['phone'] }}</span>
                        </a>
                    @endif
                    @if (!empty($company['email']))
                        <a href="mailto:{{ $company['email'] }}"
                            class="header3-contact-link hidden md:flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                                </path>
                            </svg>
                            <span>{{ $company['email'] }}</span>
                        </a>
                    @endif
                </div>
            </div>
        </div>
    </div>

    {{-- Main Header --}}
    <header class="header3-main">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-20">
                {{-- Left: Logo & Tagline with theme mode support based on header_logo_type setting --}}
                @php
                    $headerLogoType = $company['header_logo_type'] ?? 'logo_with_name';
                    $showName = in_array($headerLogoType, ['logo_with_name', 'light_dark_with_name']);
                    $useFullLogo = in_array($headerLogoType, ['light_dark_with_name', 'light_dark_only']);
                @endphp
                <div class="flex items-center gap-4">
                    <a href="{{ $homeUrl }}" wire:navigate class="flex items-center gap-3 group">
                        @if ($useFullLogo)
                            {{-- Full Logo (Light/Dark based on theme) --}}
                            <img src="{{ $company['light_logo'] ?? asset('images/light.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                                class="h-12 w-auto transition-transform group-hover:scale-105 dark:hidden" />
                            <img src="{{ $company['dark_logo'] ?? asset('images/dark.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                                class="h-12 w-auto transition-transform group-hover:scale-105 hidden dark:block" />
                        @else
                            {{-- Small Logo (Light/Dark based on theme) --}}
                            <img src="{{ $company['light_logo_small'] ?? asset('images/small_light.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                                class="h-10 w-auto transition-transform group-hover:scale-105 dark:hidden" />
                            <img src="{{ $company['dark_logo_small'] ?? asset('images/small_dark.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                                class="h-10 w-auto transition-transform group-hover:scale-105 hidden dark:block" />
                        @endif

                        @if ($showName)
                            <div class="flex flex-col">
                                <span
                                    class="header3-logo-text text-xl font-bold">{{ $company['name'] ?? 'Washville' }}</span>
                                <span
                                    class="header3-tagline text-xs">{{ $company['tagline'] ?? 'Premium Laundry Service' }}</span>
                            </div>
                        @endif
                    </a>
                </div>

                {{-- Center: Desktop Navigation --}}
                <nav class="hidden lg:flex items-center gap-2">
                    @forelse ($navItems as $index => $item)
                        @if ($index < 4)
                            <a href="{{ $item['url'] }}" wire:navigate
                                class="header3-nav-link" data-page="{{ $item['page_key'] }}">
                                {{ $item['name'] }}
                            </a>
                        @endif
                    @empty
                        <a href="{{ $homeUrl }}#services" wire:navigate class="header3-nav-link"
                            data-section="services">
                            {{ $nav['services'] ?? 'Services' }}
                        </a>
                        <a href="{{ $homeUrl }}#how-it-works" wire:navigate class="header3-nav-link"
                            data-section="how-it-works">
                            {{ $nav['how_it_works'] ?? 'How It Works' }}
                        </a>
                        <a href="{{ $homeUrl }}#pricing" wire:navigate class="header3-nav-link"
                            data-section="pricing">
                            {{ $nav['pricing'] ?? 'Pricing' }}
                        </a>
                        <a href="{{ $homeUrl }}#testimonials" wire:navigate class="header3-nav-link"
                            data-section="testimonials">
                            {{ $nav['reviews'] ?? 'Reviews' }}
                        </a>
                        <a href="{{ $homeUrl }}#faq" wire:navigate class="header3-nav-link" data-section="faq">
                            {{ $nav['faq'] ?? 'FAQ' }}
                        </a>
                        <a href="{{ $homeUrl }}#contact" wire:navigate class="header3-nav-link"
                            data-section="contact">
                            {{ $nav['contact'] ?? 'Contact' }}
                        </a>
                    @endforelse

                    {{-- More Dropdown for remaining items --}}
                    @if (count($navItems) > 4)
                        <div class="relative" x-data="{ open: false }">
                            <button @click="open = !open" @click.away="open = false"
                                class="header3-nav-link flex items-center gap-1.5">
                                {{ $section['more_text'] ?? 'More' }}
                                <svg class="w-4 h-4 transition-transform duration-200" :class="{ 'rotate-180': open }"
                                    fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </button>
                            <div x-show="open"
                                x-transition:enter="transition ease-out duration-200"
                                x-transition:enter-start="opacity-0 translate-y-2"
                                x-transition:enter-end="opacity-100 translate-y-0"
                                x-transition:leave="transition ease-in duration-150"
                                x-transition:leave-start="opacity-100 translate-y-0"
                                x-transition:leave-end="opacity-0 translate-y-2"
                                class="header3-more-dropdown absolute top-full left-0 mt-2 min-w-[180px] rounded-lg shadow-lg bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 z-50 py-1.5 overflow-hidden"
                                style="display: none;">
                                @foreach ($navItems as $index => $item)
                                    @if ($index >= 4)
                                        <a href="{{ $item['url'] }}" wire:navigate
                                            data-page="{{ $item['page_key'] }}"
                                            class="header3-more-item group flex items-center justify-between gap-2 px-4 py-2.5 text-sm text-gray-600 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700/50 hover:text-primary-600 dark:hover:text-primary-400 transition-colors duration-150">
                                            <span>{{ $item['name'] }}</span>
                                            <svg class="w-3.5 h-3.5 opacity-0 -translate-x-1 group-hover:opacity-100 group-hover:translate-x-0 transition-all duration-150 text-primary-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                            </svg>
                                        </a>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    @endif
                </nav>

                {{-- Right: Actions --}}
                <div class="flex items-center gap-3">
                    {{-- Language Dropdown (Desktop) --}}
                    @if (count($languages ?? []) > 1)
                        <div class="relative hidden lg:block" x-data="{ open: false }">
                            <button @click="open = !open" @click.away="open = false" class="header3-lang-btn"
                                aria-label="Select language">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9">
                                    </path>
                                </svg>
                                <span class="uppercase text-sm font-medium">{{ $currentLangKey }}</span>
                            </button>
                            <div x-show="open" x-transition class="header3-lang-dropdown" style="display: none;">
                                @foreach ($languages as $lang)
                                    <button type="button" wire:click="changeLanguage('{{ $lang['key'] }}')"
                                        class="w-full text-left px-4 py-2.5 text-sm hover:bg-gray-100 dark:hover:bg-gray-700 flex items-center gap-2 {{ $currentLangKey === $lang['key'] ? 'bg-primary-50 dark:bg-primary-900/20 text-primary-600 font-medium' : 'text-gray-700 dark:text-gray-300' }}">
                                        @if (!empty($lang['flag_emoji']))
                                            <span class="text-base">{{ $lang['flag_emoji'] }}</span>
                                        @endif
                                        <span>{{ $lang['name'] }}</span>
                                        @if ($currentLangKey === $lang['key'])
                                            <svg class="w-4 h-4 ml-auto text-primary-600" fill="none"
                                                stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M5 13l4 4L19 7"></path>
                                            </svg>
                                        @endif
                                    </button>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    {{-- Theme Toggle (Desktop) - Hidden for now, only light mode supported
                    @if ($section['show_theme_toggle'] ?? true)
                        <button id="theme-toggle" class="header3-theme-toggle hidden lg:flex"
                            aria-label="Toggle theme">
                            <svg class="sun-icon w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z">
                                </path>
                            </svg>
                            <svg class="moon-icon w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z">
                                </path>
                            </svg>
                        </button>
                    @endif
                    --}}

                    {{-- CTA Buttons (Desktop) --}}
                    @if (!empty($section['cta_buttons']) && is_array($section['cta_buttons']))
                        @foreach ($section['cta_buttons'] as $btnIndex => $ctaBtn)
                            @if (is_array($ctaBtn) && (!empty($ctaBtn['text']) || !empty($ctaBtn['icon'])))
                                <a href="{{ $ctaBtn['url'] ?? '#contact' }}"
                                    @if (str_starts_with($ctaBtn['url'] ?? '#contact', '#')) wire:navigate data-section="{{ ltrim($ctaBtn['url'] ?? '#contact', '#') }}" @endif
                                    class="header3-cta-btn hidden lg:flex items-center gap-2">
                                    @if (!empty($ctaBtn['icon']))<x-icon :icon="$ctaBtn['icon']" class="w-5 h-5" />@endif
                                    @if (!empty($ctaBtn['text']))<span>{{ $ctaBtn['text'] }}</span>@endif
                                </a>
                            @endif
                        @endforeach
                    @endif

                    {{-- Mobile: Menu Button --}}
                    <div class="flex items-center gap-2 lg:hidden">
                        {{-- Mobile Theme Toggle - Hidden for now, only light mode supported
                        @if ($section['show_theme_toggle'] ?? true)
                            <button id="theme-toggle-mobile" class="header3-theme-toggle-mobile"
                                aria-label="Toggle theme">
                                <svg class="sun-icon w-5 h-5" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z">
                                    </path>
                                </svg>
                                <svg class="moon-icon w-5 h-5" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z">
                                    </path>
                                </svg>
                            </button>
                        @endif
                        --}}
                        <button id="mobile-menu-btn" class="header3-mobile-btn lg:hidden">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M4 6h16M4 12h16M4 18h16">
                                </path>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </header>
</div>

{{-- Mobile Menu --}}
<div id="mobile-menu" class="header3-mobile-menu">
    <div class="flex flex-col h-full">
        {{-- Mobile Header with header_logo_type support --}}
        @php
            $mobileHeaderLogoType = $company['header_logo_type'] ?? 'logo_with_name';
            $mobileShowName = in_array($mobileHeaderLogoType, ['logo_with_name', 'light_dark_with_name']);
            $mobileUseFullLogo = in_array($mobileHeaderLogoType, ['light_dark_with_name', 'light_dark_only']);
        @endphp
        <div class="header3-mobile-header">
            <div class="flex items-center gap-3">
                @if ($mobileUseFullLogo)
                    {{-- Full Logo for mobile (using dark logo since mobile menu has dark background) --}}
                    <img src="{{ $company['dark_logo'] ?? asset('images/dark.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="h-10 w-auto" />
                @else
                    {{-- Small Logo for mobile (using dark logo since mobile menu has dark background) --}}
                    <img src="{{ $company['dark_logo_small'] ?? asset('images/small_dark.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="h-8 w-auto" />
                @endif

                @if ($mobileShowName)
                    <div>
                        <div class="text-lg font-bold">{{ $company['name'] ?? 'Washville' }}</div>
                        <div class="text-xs opacity-90">{{ $company['tagline'] ?? 'Premium Service' }}</div>
                    </div>
                @endif
            </div>
            <button id="mobile-menu-close" class="header3-mobile-close">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                    </path>
                </svg>
            </button>
        </div>

        {{-- Mobile Navigation --}}
        <nav class="flex-1 overflow-y-auto py-4">
            @forelse ($navItems as $item)
                <a href="{{ $item['url'] }}" data-page="{{ $item['page_key'] }}"
                    class="header3-mobile-link mobile-menu-link">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7">
                        </path>
                    </svg>
                    <span>{{ $item['name'] }}</span>
                </a>
            @empty
                <a href="{{ $homeUrl }}#services" data-section="services"
                    class="header3-mobile-link mobile-menu-link">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7">
                        </path>
                    </svg>
                    <span>{{ $nav['services'] ?? 'Services' }}</span>
                </a>
                <a href="{{ $homeUrl }}#how-it-works" data-section="how-it-works"
                    class="header3-mobile-link mobile-menu-link">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7">
                        </path>
                    </svg>
                    <span>{{ $nav['how_it_works'] ?? 'How It Works' }}</span>
                </a>
                <a href="{{ $homeUrl }}#pricing" data-section="pricing"
                    class="header3-mobile-link mobile-menu-link">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7">
                        </path>
                    </svg>
                    <span>{{ $nav['pricing'] ?? 'Pricing' }}</span>
                </a>
                <a href="{{ $homeUrl }}#testimonials" data-section="testimonials"
                    class="header3-mobile-link mobile-menu-link">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7">
                        </path>
                    </svg>
                    <span>{{ $nav['reviews'] ?? 'Reviews' }}</span>
                </a>
                <a href="{{ $homeUrl }}#faq" data-section="faq" class="header3-mobile-link mobile-menu-link">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7">
                        </path>
                    </svg>
                    <span>{{ $nav['faq'] ?? 'FAQ' }}</span>
                </a>
                <a href="{{ $homeUrl }}#contact" data-section="contact"
                    class="header3-mobile-link mobile-menu-link">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7">
                        </path>
                    </svg>
                    <span>{{ $nav['contact'] ?? 'Contact' }}</span>
                </a>
            @endforelse
        </nav>

        {{-- Mobile Language Selector --}}
        @if (count($languages ?? []) > 1)
            <div class="px-4 py-3 border-t border-gray-200 dark:border-gray-700">
                <p class="text-sm font-medium text-gray-500 dark:text-gray-400 mb-3">Language</p>
                <div class="flex flex-wrap gap-2">
                    @foreach ($languages as $lang)
                        <button type="button" wire:click="changeLanguage('{{ $lang['key'] }}')"
                            class="px-3 py-2 text-sm rounded-lg flex items-center gap-2 transition-colors {{ $currentLangKey === $lang['key'] ? 'bg-primary-600 text-white' : 'bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300 hover:bg-gray-200 dark:hover:bg-gray-600' }}">
                            @if (!empty($lang['flag_emoji']))
                                <span>{{ $lang['flag_emoji'] }}</span>
                            @endif
                            <span>{{ $lang['name'] }}</span>
                        </button>
                    @endforeach
                </div>
            </div>
        @endif

        {{-- Mobile Footer --}}
        <div class="header3-mobile-footer">
            {{-- Contact Info --}}
            <div class="space-y-2 mb-4">
                @if (!empty($company['phone']))
                    <a href="tel:{{ $company['phone'] }}" class="header3-mobile-contact">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                            </path>
                        </svg>
                        <span>{{ $company['phone'] }}</span>
                    </a>
                @endif
                @if (!empty($company['email']))
                    <a href="mailto:{{ $company['email'] }}" class="header3-mobile-contact">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                            </path>
                        </svg>
                        <span>{{ $company['email'] }}</span>
                    </a>
                @endif
            </div>

            {{-- CTA Buttons --}}
            @if (!empty($section['cta_buttons']) && is_array($section['cta_buttons']))
                <div class="space-y-2">
                    @foreach ($section['cta_buttons'] as $btnIndex => $ctaBtn)
                        @if (is_array($ctaBtn) && (!empty($ctaBtn['text']) || !empty($ctaBtn['icon'])))
                            <a href="{{ $ctaBtn['url'] ?? '#contact' }}"
                                @if (str_starts_with($ctaBtn['url'] ?? '#contact', '#')) data-section="{{ ltrim($ctaBtn['url'] ?? '#contact', '#') }}" @endif
                                class="header3-mobile-cta mobile-menu-link flex items-center justify-center gap-2">
                                @if (!empty($ctaBtn['icon']))<x-icon :icon="$ctaBtn['icon']" class="w-5 h-5" />@endif
                                @if (!empty($ctaBtn['text']))<span>{{ $ctaBtn['text'] }}</span>@endif
                            </a>
                        @endif
                    @endforeach
                </div>
            @endif
        </div>
    </div>
</div>

{{-- Mobile Menu Overlay --}}
<div id="mobile-menu-overlay" class="header3-overlay"></div>
</div>



@script
    <script>
        // Language change reload
        // Remove 'lang' query parameter if present before reload
        $wire.on('language-changed', () => {
            const url = new URL(window.location.href);
            if (url.searchParams.has('lang')) {
                url.searchParams.delete('lang');
                window.location.href = url.toString();
            } else {
                window.location.reload();
            }
        });

        // Function to close mobile menu
        function closeMobileMenu() {
            const mobileMenu = document.getElementById('mobile-menu');
            const overlay = document.getElementById('mobile-menu-overlay');

            if (mobileMenu) {
                mobileMenu.classList.remove('active');
            }
            if (overlay) {
                overlay.classList.remove('active');
            }
            document.body.style.overflow = '';
        }

        // Mobile menu overlay functionality specific to header3
        const overlay = document.getElementById('mobile-menu-overlay');
        if (overlay) {
            overlay.addEventListener('click', closeMobileMenu);
        }

        // Update mobile menu toggle for header3 to also control overlay
        const menuBtn = document.getElementById('mobile-menu-btn');
        const closeBtn = document.getElementById('mobile-menu-close');
        const mobileMenu = document.getElementById('mobile-menu');

        if (menuBtn && mobileMenu && overlay) {
            menuBtn.addEventListener('click', (e) => {
                e.stopPropagation();
                mobileMenu.classList.add('active');
                overlay.classList.add('active');
                document.body.style.overflow = 'hidden';
            });
        }

        if (closeBtn) {
            closeBtn.addEventListener('click', closeMobileMenu);
        }

        // Close menu when clicking on mobile menu links
        const mobileMenuLinks = document.querySelectorAll('.mobile-menu-link');
        mobileMenuLinks.forEach(link => {
            link.addEventListener('click', () => {
                // Small delay to allow navigation to start
                setTimeout(closeMobileMenu, 100);
            });
        });
    </script>
@endscript

</div>