<?php
use Livewire\Component;
?>

<div>
<section id="services" class="services-section {{ $isWhiteBackground ? 'services-white' : 'services-gray' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    {{-- Decorative Background Elements --}}
    <div class="services-bg-decoration">
        <div class="services-blob services-blob-1"></div>
        <div class="services-blob services-blob-2"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        {{-- Section Header --}}
        <div class="services-header">
            <span class="services-badge">
                <x-icon icon="lucide:sparkles" class="w-4 h-4" />
                <span>{{ $section['badge'] }}</span>
            </span>
            <h2 class="services-title">{{ $section['title'] }}</h2>
            <p class="services-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Services Grid --}}
        <div class="services-grid">
            @foreach ($items as $index => $item)
                <div class="service-card scroll-animate" style="animation-delay: {{ $index * 100 }}ms">
                    {{-- Card Glow Effect --}}
                    <div class="service-card-glow"></div>

                    {{-- Card Content --}}
                    <div class="service-card-inner">
                        {{-- Icon --}}
                        <div class="service-icon">
                            <x-icon icon="{{ $item['icon'] ?? 'heroicons:sparkles' }}" class="w-7 h-7" />
                        </div>

                        {{-- Content --}}
                        <div class="service-content">
                            <h3 class="service-title">{{ $item['title'] ?? '' }}</h3>
                            <p class="service-description">{{ $item['description'] ?? '' }}</p>
                        </div>

                        {{-- Price Tag --}}
                        @if (!empty($item['price']))
                            <div class="service-price">
                                <span>{{ $item['price'] }}</span>
                            </div>
                        @endif

                        {{-- Features --}}
                        @if (!empty($item['features']))
                            <ul class="service-features">
                                @foreach ($item['features'] as $feature)
                                    <li class="service-feature">
                                        <span class="service-feature-icon">
                                            <x-icon icon="lucide:check" class="w-3.5 h-3.5" />
                                        </span>
                                        {{-- Support both string format and object format from CMS --}}
                                        <span>{{ is_array($feature) ? ($feature['text'] ?? '') : $feature }}</span>
                                    </li>
                                @endforeach
                            </ul>
                        @endif

                        {{-- Action Button --}}
                        @if (!empty($item['button_text']) && !empty($item['button_url']))
                            <a href="{{ $item['button_url'] }}" class="service-button">
                                <span>{{ $item['button_text'] }}</span>
                                <x-icon icon="{{ $item['button_icon'] ?? 'lucide:arrow-right' }}" class="w-4 h-4" />
                            </a>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>


</div>