<?php
use Livewire\Component;
?>

<div>
    


    <section id="team"
        class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        <div class="team-split-container max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Background Shapes --}}
            <div class="team-split-shapes">
                <div class="team-split-circle team-split-circle-1"></div>
                <div class="team-split-circle team-split-circle-2"></div>
                <div class="team-split-dots"></div>
            </div>

            <div class="grid lg:grid-cols-12 gap-12 items-start">
                {{-- Left Side - Title & Description --}}
                <div class="lg:col-span-4 team-split-left scroll-animate" data-animation="fade-up">
                    <div class="lg:sticky lg:top-32">
                        @if (!empty($section['badge']))
                            <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                        @endif

                        <h2 class="team-split-title-decoration section-title text-start mb-6">
                            {{ $section['title'] }}
                        </h2>

                        @if (!empty($section['subtitle']))
                            <p class="text-gray-600 dark:text-gray-400 text-lg leading-relaxed mb-8">
                                {{ $section['subtitle'] }}
                            </p>
                        @endif

                        {{-- Stats --}}
                        <div class="team-split-stat">
                            <div class="team-split-stat-icon">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                                </svg>
                            </div>
                            <div>
                                <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ count($items) }}+</p>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Right Side - Team Grid --}}
                <div class="lg:col-span-8">
                    <div class="grid sm:grid-cols-2 gap-6">
                        @foreach ($items as $index => $member)
                            <div class="team-split-card scroll-animate" data-animation="fade-up"
                                style="animation-delay: {{ $index * 100 }}ms">
                                <div class="team-split-card-shape"></div>

                                {{-- Image --}}
                                <div class="team-split-image-wrapper">
                                    @php
                                        $imageUrl = $member['image_url'] ?? ($member['image'] ?? null);
                                        $defaultPlaceholder =
                                            'https://ui-avatars.com/api/?name=' .
                                            urlencode($member['name'] ?? 'Team') .
                                            '&size=300&background=random&color=fff&bold=true';
                                    @endphp
                                    <img src="{{ $imageUrl ?: $defaultPlaceholder }}" alt="{{ $member['name'] ?? '' }}"
                                        class="team-split-image" loading="lazy">
                                </div>

                                {{-- Content --}}
                                <div class="team-split-content">
                                    <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-1">
                                        {{ $member['name'] ?? '' }}
                                    </h3>

                                    @if (!empty($member['position']) || !empty($member['role']))
                                        <p class="text-primary-600 dark:text-primary-400 text-sm font-medium mb-2">
                                            {{ $member['position'] ?? $member['role'] }}
                                        </p>
                                    @endif

                                    @if (!empty($member['bio']))
                                        <p class="text-gray-600 dark:text-gray-400 text-sm line-clamp-2">
                                            {{ $member['bio'] }}
                                        </p>
                                    @endif

                                    @if (!empty($member['social_links']))
                                        <div class="team-split-social">
                                            @foreach ($member['social_links'] as $social)
                                                <a href="{{ $social['url'] ?? '#' }}" target="_blank" rel="noopener">
                                                    <x-icon icon="{{ $social['icon'] ?? 'mdi:link' }}"
                                                        class="w-4 h-4" />
                                                </a>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>