<?php
use Livewire\Component;
?>

<div>
    

    <section id="team"
        class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Section Header --}}
            <div class="text-center mb-16 scroll-animate" data-animation="fade-up">
                @if (!empty($section['badge']))
                    <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                @endif
                <h2 class="section-title">{{ $section['title'] }}</h2>
                @if (!empty($section['subtitle']))
                    <p class="section-subtitle">{{ $section['subtitle'] }}</p>
                @endif
            </div>

            {{-- Team Grid --}}
            <div class="grid sm:grid-cols-2 lg:grid-cols-4 gap-6">
                @foreach ($items as $index => $member)
                    <div class="team-minimal-card scroll-animate" data-animation="fade-up"
                        style="animation-delay: {{ $index * 100 }}ms">
                        {{-- Image --}}
                        <div class="team-minimal-image-container">
                            <div class="team-minimal-image-ring"></div>
                            @php
                                $imageUrl = $member['image_url'] ?? ($member['image'] ?? null);
                                $defaultPlaceholder =
                                    'https://ui-avatars.com/api/?name=' .
                                    urlencode($member['name'] ?? 'Team') .
                                    '&size=300&background=random&color=fff&bold=true';
                            @endphp
                            <img src="{{ $imageUrl ?: $defaultPlaceholder }}" alt="{{ $member['name'] ?? '' }}"
                                class="team-minimal-image" loading="lazy">
                        </div>

                        {{-- Divider --}}
                        <div class="team-minimal-divider"></div>

                        {{-- Name --}}
                        <h3 class="team-minimal-name">{{ $member['name'] ?? '' }}</h3>

                        {{-- Position --}}
                        @if (!empty($member['position']) || !empty($member['role']))
                            <p class="team-minimal-position">{{ $member['position'] ?? $member['role'] }}</p>
                        @endif

                        {{-- Bio --}}
                        @if (!empty($member['bio']))
                            <p class="team-minimal-bio line-clamp-2">{{ $member['bio'] }}</p>
                        @endif

                        {{-- Social Links --}}
                        @if (!empty($member['social_links']))
                            <div class="team-minimal-social">
                                @foreach ($member['social_links'] as $social)
                                    <a href="{{ $social['url'] ?? '#' }}" target="_blank" rel="noopener">
                                        <x-icon icon="{{ $social['icon'] ?? 'mdi:link' }}" class="w-4 h-4" />
                                    </a>
                                @endforeach
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </section>
</div>