<?php
use Livewire\Component;
?>

{{-- Contact Section 3: Split Screen with Animated Shapes --}}
<section id="contact" class="section relative overflow-hidden"
    @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>

    <div class="flex flex-col lg:flex-row min-h-[700px]">
        {{-- Left Side - Dark with Pattern --}}
        <div class="lg:w-1/2 bg-gradient-to-br from-gray-900 via-gray-800 to-gray-900 relative py-16 lg:py-24 px-6 lg:px-12">
            {{-- Animated Pattern Background --}}
            <div class="absolute inset-0 overflow-hidden">
                {{-- Dot Pattern --}}
                <div class="absolute inset-0 opacity-10"
                    style="background-image: radial-gradient(circle, rgba(255,255,255,0.3) 1px, transparent 1px); background-size: 30px 30px;">
                </div>
                {{-- Floating Shapes --}}
                <div class="absolute top-10 left-10 w-32 h-32 border border-primary-500/30 rounded-full"
                    style="animation: float 6s ease-in-out infinite;"></div>
                <div class="absolute bottom-20 right-10 w-24 h-24 border border-secondary-500/30 rounded-lg rotate-45"
                    style="animation: float 8s ease-in-out infinite reverse;"></div>
                <div class="absolute top-1/2 left-1/4 w-16 h-16 bg-primary-500/10 rounded-full blur-xl"
                    style="animation: pulse 4s ease-in-out infinite;"></div>
                <div class="absolute bottom-1/3 right-1/4 w-20 h-20 bg-secondary-500/10 rounded-full blur-xl"
                    style="animation: pulse 5s ease-in-out infinite;"></div>
                {{-- Gradient Line --}}
                <div class="absolute top-0 right-0 w-1 h-full bg-gradient-to-b from-primary-500 via-secondary-500 to-primary-500 opacity-50"></div>
            </div>

            <div class="relative z-10 max-w-lg mx-auto lg:mx-0">
                <span class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-primary-500/20 text-primary-400 text-sm font-medium mb-6">
                    <span class="w-2 h-2 rounded-full bg-primary-400 animate-pulse"></span>
                    {{ $section['badge'] }}
                </span>
                <h2 class="text-4xl lg:text-5xl font-bold text-white mb-6 leading-tight">{{ $section['title'] }}</h2>
                <p class="text-gray-400 text-lg mb-10">{{ $section['subtitle'] }}</p>

                {{-- Contact List --}}
                <div class="space-y-6">
                    {{-- Phone --}}
                    <a href="tel:{{ $company['phone'] }}" class="group flex items-center gap-5 p-4 rounded-2xl bg-white/5 hover:bg-white/10 backdrop-blur-sm transition-all duration-300 border border-white/10 hover:border-primary-500/50">
                        <div class="w-14 h-14 rounded-xl bg-gradient-to-br from-primary-500 to-primary-600 flex items-center justify-center flex-shrink-0 group-hover:scale-110 transition-transform">
                            <x-icon icon="heroicons:phone" class="w-6 h-6 text-white" />
                        </div>
                        <div>
                            <p class="text-gray-400 text-sm mb-1">{{ $section['info_phone_label'] }}</p>
                            <p class="text-white font-semibold text-lg group-hover:text-primary-400 transition-colors">{{ $company['phone'] }}</p>
                        </div>
                        <x-icon icon="heroicons:arrow-right" class="w-5 h-5 text-gray-500 group-hover:text-primary-400 ms-auto transition-all group-hover:translate-x-1" />
                    </a>

                    {{-- Email --}}
                    <a href="mailto:{{ $company['email'] }}" class="group flex items-center gap-5 p-4 rounded-2xl bg-white/5 hover:bg-white/10 backdrop-blur-sm transition-all duration-300 border border-white/10 hover:border-secondary-500/50">
                        <div class="w-14 h-14 rounded-xl bg-gradient-to-br from-secondary-500 to-secondary-600 flex items-center justify-center flex-shrink-0 group-hover:scale-110 transition-transform">
                            <x-icon icon="heroicons:envelope" class="w-6 h-6 text-white" />
                        </div>
                        <div class="min-w-0 flex-1">
                            <p class="text-gray-400 text-sm mb-1">{{ $section['info_email_label'] }}</p>
                            <p class="text-white font-semibold text-lg group-hover:text-secondary-400 transition-colors truncate">{{ $company['email'] }}</p>
                        </div>
                        <x-icon icon="heroicons:arrow-right" class="w-5 h-5 text-gray-500 group-hover:text-secondary-400 ms-auto transition-all group-hover:translate-x-1 flex-shrink-0" />
                    </a>

                    {{-- Address --}}
                    <div class="group flex items-center gap-5 p-4 rounded-2xl bg-white/5 backdrop-blur-sm border border-white/10">
                        <div class="w-14 h-14 rounded-xl bg-gradient-to-br from-primary-500 to-secondary-500 flex items-center justify-center flex-shrink-0">
                            <x-icon icon="heroicons:map-pin" class="w-6 h-6 text-white" />
                        </div>
                        <div>
                            <p class="text-gray-400 text-sm mb-1">{{ $section['info_address_label'] }}</p>
                            <p class="text-white font-semibold">{{ $company['address'] }}</p>
                        </div>
                    </div>

                    {{-- Hours --}}
                    <div class="group flex items-center gap-5 p-4 rounded-2xl bg-white/5 backdrop-blur-sm border border-white/10">
                        <div class="w-14 h-14 rounded-xl bg-gradient-to-br from-secondary-500 to-primary-500 flex items-center justify-center flex-shrink-0">
                            <x-icon icon="heroicons:clock" class="w-6 h-6 text-white" />
                        </div>
                        <div>
                            <p class="text-gray-400 text-sm mb-1">{{ $section['info_hours_label'] }}</p>
                            <p class="text-white font-semibold">{{ $company['hours'] }}</p>
                        </div>
                    </div>
                </div>

                {{-- Social Links --}}
                @if (($social['show_icon'] ?? true) && count($social ?? []) > 0)
                    <div class="mt-10 pt-10 border-t border-white/10">
                        <p class="text-gray-400 text-sm mb-5">{{ $section['info_follow_us_label'] }}</p>
                        <div class="flex gap-4">
                            @foreach ($social as $key => $link)
                                @if ($key !== 'show_icon' && is_array($link))
                                    <a href="{{ $link['url'] }}" target="_blank" rel="noopener noreferrer"
                                        class="w-11 h-11 rounded-xl bg-white/10 flex items-center justify-center text-gray-400 hover:bg-primary-500 hover:text-white transition-all duration-300 hover:scale-110">
                                        <x-icon icon="{{ $link['icon'] ?? 'mdi:link' }}" class="w-5 h-5" />
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </div>

        {{-- Right Side - Map --}}
        <div class="lg:w-1/2 {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }} relative">
            <div class="absolute inset-0">
                <iframe src="{{ $section['google_map_url'] }}" width="100%" height="100%" style="border:0;"
                    allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade">
                </iframe>
            </div>
            {{-- Map Overlay Card --}}
            <div class="absolute bottom-6 left-6 right-6 lg:left-8 lg:right-8 lg:bottom-8">
                <div class="bg-white dark:bg-gray-800 rounded-2xl p-5 shadow-2xl border border-gray-100 dark:border-gray-700">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 rounded-full bg-primary-100 dark:bg-primary-900/30 flex items-center justify-center">
                                <x-icon icon="heroicons:map-pin" class="w-5 h-5 text-primary-600" />
                            </div>
                            <div>
                                <p class="font-semibold text-gray-900 dark:text-white text-sm">{{ $section['info_address_label'] }}</p>
                                <p class="text-gray-500 dark:text-gray-400 text-xs truncate max-w-[200px]">{{ $company['address'] }}</p>
                            </div>
                        </div>
                        <a href="{{ $section['google_map_link_url'] }}" target="_blank"
                            class="inline-flex items-center gap-2 px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white text-sm font-medium rounded-xl transition-colors">
                            <x-icon icon="heroicons:arrow-top-right-on-square" class="w-4 h-4" />
                            <span class="hidden sm:inline">{{ $section['open_in_maps_text'] }}</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
</section>