<?php
use Livewire\Component;
use App\Models\WebsitePage;
use App\Models\WebsitePageTranslation;
use App\Models\WebsiteLanguage;
?>

@php
    $textColorMode = $section['text_color_mode'] ?? 'auto';
    $textColorClass = match($textColorMode) {
        'light' => 'header-text-light',
        'dark' => 'header-text-dark',
        default => '',
    };
    $isSolidHeader = !($section['transparent'] ?? true);
@endphp
<div>
<header id="header"
    class="{{ $section['sticky'] ?? true ? 'fixed' : 'relative' }} top-0 left-0 right-0 z-50 transition-all duration-300 {{ $isSolidHeader ? 'header-solid' : 'header-transparent' }} {{ $textColorClass }}"
    data-transparent="{{ $isSolidHeader ? 'false' : 'true' }}"
    data-text-color-mode="{{ $textColorMode }}"
    data-solid="{{ $isSolidHeader ? 'true' : 'false' }}">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex items-center justify-between h-20">
            {{-- Logo with theme mode support based on header_logo_type setting --}}
            @php
                $headerLogoType = $company['header_logo_type'] ?? 'logo_with_name';
                $showName = in_array($headerLogoType, ['logo_with_name', 'light_dark_with_name']);
                $useFullLogo = in_array($headerLogoType, ['light_dark_with_name', 'light_dark_only']);
            @endphp
            <a href="{{ $homeUrl }}" wire:navigate class="flex items-center gap-2">
                @if ($useFullLogo)
                    {{-- Full Logo (Light/Dark based on theme) --}}
                    <img src="{{ $company['light_logo'] ?? asset('images/light.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="h-8 w-auto dark:hidden" />
                    <img src="{{ $company['dark_logo'] ?? asset('images/dark.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="h-8 w-auto hidden dark:block" />
                @else
                    {{-- Small Logo (Light/Dark based on theme) --}}
                    <img src="{{ $company['light_logo_small'] ?? asset('images/small_light.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="h-8 w-auto dark:hidden" />
                    <img src="{{ $company['dark_logo_small'] ?? asset('images/small_dark.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="h-8 w-auto hidden dark:block" />
                @endif

                @if ($showName)
                    <span class="header-logo-text text-xl font-bold">{{ $company['name'] ?? 'Washville' }}</span>
                @endif
            </a>

            {{-- Desktop Navigation - Business Pages with show_in_header --}}
            @php
                // Show max 4 items in header, rest go to More dropdown
                $maxVisibleItems = 4;
                $totalHeaderPages = count($headerPages);
                $hasMoreHeaderPages = $totalHeaderPages > $maxVisibleItems;
            @endphp
            <nav class="hidden md:flex items-center gap-4 lg:gap-6 flex-nowrap">
                @forelse ($headerPages as $index => $page)
                    @if ($index < $maxVisibleItems)
                        <a href="{{ $page['url'] }}" wire:navigate class="nav-link whitespace-nowrap text-sm lg:text-base">{{ $page['name'] }}</a>
                    @endif
                @empty
                    {{-- No pages configured to show in header --}}
                @endforelse

                {{-- More Dropdown for remaining items --}}
                @if ($hasMoreHeaderPages)
                    <div class="relative" x-data="{ open: false }">
                        <button @click="open = !open" @click.away="open = false"
                            class="nav-link flex items-center gap-1.5 group">
                            {{ $section['more_text'] ?? 'More' }}
                            <x-icon icon="heroicons:chevron-down"
                                class="w-4 h-4 transition-transform duration-200"
                                x-bind:class="{ 'rotate-180': open }" />
                        </button>
                        <div x-show="open"
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 translate-y-2"
                            x-transition:enter-end="opacity-100 translate-y-0"
                            x-transition:leave="transition ease-in duration-150"
                            x-transition:leave-start="opacity-100 translate-y-0"
                            x-transition:leave-end="opacity-0 translate-y-2"
                            class="nav-more-dropdown absolute top-full left-1/2 -translate-x-1/2 mt-2 min-w-[180px] rounded-lg shadow-lg bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 z-50 py-1.5 overflow-hidden"
                            style="display: none;">
                            @foreach ($headerPages as $index => $page)
                                @if ($index >= $maxVisibleItems)
                                    <a href="{{ $page['url'] }}" wire:navigate
                                        class="nav-more-item group flex items-center justify-between gap-2 px-4 py-2.5 text-sm text-gray-600 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700/50 hover:text-primary-600 dark:hover:text-primary-400 transition-colors duration-150">
                                        <span>{{ $page['name'] }}</span>
                                        <svg class="w-3.5 h-3.5 opacity-0 -translate-x-1 group-hover:opacity-100 group-hover:translate-x-0 transition-all duration-150 text-primary-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                        </svg>
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif
            </nav>

            {{-- CTA Button & Theme Toggle --}}
            <div class="hidden md:flex items-center gap-4">
                {{-- Language Dropdown --}}
                @if (count($languages ?? []) > 1)
                    <div class="relative" x-data="{ open: false }">
                        <button @click="open = !open" @click.away="open = false"
                            class="flex items-center gap-1 px-2 py-1 rounded-lg text-sm font-medium header-lang-btn transition-colors"
                            aria-label="Select language">
                            <x-icon icon="heroicons:globe-alt" class="w-4 h-4" />
                            <span class="uppercase" id="current-lang-display">{{ $currentLangKey }}</span>
                            <x-icon icon="heroicons:chevron-down" class="w-3 h-3 transition-transform"
                                x-bind:class="{ 'rotate-180': open }" />
                        </button>
                        <div x-show="open" x-transition:enter="transition ease-out duration-100"
                            x-transition:enter-start="transform opacity-0 scale-95"
                            x-transition:enter-end="transform opacity-100 scale-100"
                            x-transition:leave="transition ease-in duration-75"
                            x-transition:leave-start="transform opacity-100 scale-100"
                            x-transition:leave-end="transform opacity-0 scale-95"
                            class="absolute right-0 mt-2 w-40 rounded-lg shadow-lg bg-white dark:bg-gray-800 ring-1 ring-black ring-opacity-5 z-50 py-1"
                            style="display: none;">
                            @foreach ($languages as $lang)
                                <button type="button" wire:click="changeLanguage('{{ $lang['key'] }}')"
                                    class="w-full text-left px-4 py-2 text-sm hover:bg-gray-100 dark:hover:bg-gray-700 flex items-center gap-2 {{ $currentLangKey === $lang['key'] ? 'bg-primary-50 dark:bg-primary-900/20 text-primary-600' : 'text-gray-700 dark:text-gray-300' }}">
                                    @if (!empty($lang['flag_code']))
                                        <span class="text-lg">{{ $lang['flag_emoji'] ?? '' }}</span>
                                    @endif
                                    <span>{{ $lang['name'] }}</span>
                                    @if ($currentLangKey === $lang['key'])
                                        <x-icon icon="heroicons:check" class="w-4 h-4 ml-auto text-primary-600" />
                                    @endif
                                </button>
                            @endforeach
                        </div>
                    </div>
                @endif

                {{-- Theme Toggle Button - Hidden for now, only light mode supported
                @if ($section['show_theme_toggle'] ?? true)
                    <button id="theme-toggle" class="theme-toggle" aria-label="Toggle theme">
                        <x-icon icon="heroicons:sun" class="sun-icon w-5 h-5" />
                        <x-icon icon="heroicons:moon" class="moon-icon w-5 h-5" />
                    </button>
                @endif
                --}}
                @if (!empty($section['cta_buttons']) && is_array($section['cta_buttons']))
                    @foreach ($section['cta_buttons'] as $btnIndex => $ctaBtn)
                        @if (is_array($ctaBtn) && (!empty($ctaBtn['text']) || !empty($ctaBtn['icon'])))
                            <a href="{{ $ctaBtn['url'] ?? '#contact' }}"
                                class="header-cta-btn hidden md:flex items-center gap-2"
                                @if (str_starts_with($ctaBtn['url'] ?? '#contact', '#')) wire:navigate data-section="{{ ltrim($ctaBtn['url'] ?? '#contact', '#') }}" @endif>
                                @if (!empty($ctaBtn['icon']))<x-icon :icon="$ctaBtn['icon']" class="w-5 h-5" />@endif
                                @if (!empty($ctaBtn['text']))<span>{{ $ctaBtn['text'] }}</span>@endif
                            </a>
                        @endif
                    @endforeach
                @endif
            </div>

            {{-- Mobile Menu Button --}}
            <div class="flex items-center gap-2 md:hidden">
                {{-- Mobile Theme Toggle - Hidden for now, only light mode supported
                @if ($section['show_theme_toggle'] ?? true)
                    <button id="theme-toggle-mobile" class="theme-toggle" aria-label="Toggle theme">
                        <x-icon icon="heroicons:sun" class="sun-icon w-5 h-5" />
                        <x-icon icon="heroicons:moon" class="moon-icon w-5 h-5" />
                    </button>
                @endif
                --}}
                <button id="mobile-menu-btn" class="header-mobile-btn p-2 rounded-lg transition-colors">
                    <x-icon icon="heroicons:bars-3" class="w-6 h-6" />
                </button>
            </div>
        </div>
    </div>
</header>

{{-- Mobile Menu (Outside header for proper z-index stacking) --}}
<div id="mobile-menu" class="mobile-menu">
    <div class="flex flex-col h-full">
        <div class="flex items-center justify-between p-4 border-b">
            <div class="flex items-center gap-2">
                @if ($useFullLogo)
                    <img src="{{ $company['light_logo'] ?? asset('images/light.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="h-8 w-auto dark:hidden" />
                    <img src="{{ $company['dark_logo'] ?? asset('images/dark.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="h-8 w-auto hidden dark:block" />
                @else
                    <img src="{{ $company['light_logo_small'] ?? asset('images/small_light.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="h-8 w-auto dark:hidden" />
                    <img src="{{ $company['dark_logo_small'] ?? asset('images/small_dark.png') }}" alt="{{ $company['name'] ?? 'Logo' }}"
                        class="h-8 w-auto hidden dark:block" />
                @endif
                @if ($showName)
                    <span class="text-xl font-bold">{{ $company['name'] ?? 'Washville' }}</span>
                @endif
            </div>
            <button id="mobile-menu-close" class="p-2 rounded-lg hover:bg-gray-100">
                <x-icon icon="heroicons:x-mark" class="w-6 h-6" />
            </button>
        </div>
        <nav class="flex-1 p-4 space-y-4 overflow-y-auto">
            @forelse ($headerPages as $page)
                <a href="{{ $page['url'] }}"
                    class="mobile-menu-link block py-3 text-lg font-medium text-gray-700 hover:text-primary-600">{{ $page['name'] }}</a>
            @empty
                {{-- No pages configured to show in header --}}
            @endforelse
        </nav>
        {{-- Mobile Language Selector --}}
        @if (count($languages ?? []) > 1)
            <div class="p-4 border-t">
                <p class="text-sm font-medium text-gray-500 dark:text-gray-400 mb-2">Language</p>
                <div class="flex flex-wrap gap-2">
                    @foreach ($languages as $lang)
                        <button type="button" wire:click="changeLanguage('{{ $lang['key'] }}')"
                            class="px-3 py-2 text-sm rounded-lg flex items-center gap-2 {{ $currentLangKey === $lang['key'] ? 'bg-primary-600 text-white' : 'bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300 hover:bg-gray-200 dark:hover:bg-gray-600' }}">
                            @if (!empty($lang['flag_emoji']))
                                <span>{{ $lang['flag_emoji'] }}</span>
                            @endif
                            <span>{{ $lang['name'] }}</span>
                        </button>
                    @endforeach
                </div>
            </div>
        @endif

        @if (!empty($section['cta_buttons']) && is_array($section['cta_buttons']))
            <div class="p-4 border-t space-y-2">
                @foreach ($section['cta_buttons'] as $btnIndex => $ctaBtn)
                    @if (is_array($ctaBtn) && (!empty($ctaBtn['text']) || !empty($ctaBtn['icon'])))
                        <a href="{{ $ctaBtn['url'] ?? '#contact' }}"
                            @if (str_starts_with($ctaBtn['url'] ?? '#contact', '#')) data-section="{{ ltrim($ctaBtn['url'] ?? '#contact', '#') }}" @endif
                            class="header-mobile-cta mobile-menu-link flex items-center justify-center gap-2">
                            @if (!empty($ctaBtn['icon']))<x-icon :icon="$ctaBtn['icon']" class="w-5 h-5" />@endif
                            @if (!empty($ctaBtn['text']))<span>{{ $ctaBtn['text'] }}</span>@endif
                        </a>
                    @endif
                @endforeach
            </div>
        @endif
    </div>
</div>
</div>



{{-- Script to handle dark mode for header (solid and transparent when scrolled) --}}


{{-- Language Change Script --}}
@script
    <script>
        // Listen for Livewire language-changed event and reload the page
        // Remove 'lang' query parameter if present before reload
        $wire.on('language-changed', () => {
            const url = new URL(window.location.href);
            if (url.searchParams.has('lang')) {
                url.searchParams.delete('lang');
                window.location.href = url.toString();
            } else {
                window.location.reload();
            }
        });
    </script>
@endscript

</div>