<?php
use Livewire\Component;
?>

<div>
    <section class="hero1-section" @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Background Pattern --}}
        <div class="hero1-bg-pattern"></div>

        {{-- Gradient Overlay --}}
        <div class="hero1-gradient-overlay"></div>

        <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="hero1-content-wrapper">
                {{-- Main Content - Centered --}}
                <div class="hero1-center-content">
                    {{-- Badge --}}
                    <div class="hero1-badge animate-fade-in-down">
                        <span class="hero1-badge-dot"></span>
                        <span>{{ $hero['badge'] }}</span>
                    </div>

                    {{-- Title --}}
                    <h1 class="hero1-title animate-fade-in-up">
                        {{ $hero['title'] }}
                        <span class="hero1-title-highlight">{{ $hero['subtitle'] }}</span>
                    </h1>

                    {{-- Description --}}
                    <p class="hero1-description animate-fade-in-up delay-200">
                        {{ $hero['description'] }}
                    </p>

                    {{-- Stats - Inline List --}}
                    @if (!empty($hero['stats']))
                        <div class="hero1-inline-stats animate-fade-in-up delay-250">
                            @foreach ($hero['stats'] as $stat)
                                <div class="hero1-inline-stat-item">
                                    @if (!empty($stat['icon']))
                                        <div class="hero1-inline-stat-icon">
                                            <x-icon icon="{{ $stat['icon'] }}" class="w-5 h-5" />
                                        </div>
                                    @endif
                                    <div class="hero1-inline-stat-text">
                                        @if (!empty($stat['value']))
                                            <span class="hero1-inline-stat-value">{{ $stat['value'] }}</span>
                                        @endif
                                        @if (!empty($stat['label']))
                                            <span class="hero1-inline-stat-label">{{ $stat['label'] }}</span>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    {{-- CTA Buttons --}}
                    <div class="hero1-cta-group animate-fade-in-up delay-300">
                        @foreach ($hero['buttons'] ?? [] as $index => $button)
                            @if ($button['is_transparent'] ?? false)
                                <a href="{{ $button['url'] ?? '#' }}" class="hero1-btn-secondary">
                                    @if (!empty($button['icon']))
                                        <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                    @endif
                                    @if (!empty($button['text']))
                                        <span>{{ $button['text'] }}</span>
                                    @endif
                                </a>
                            @else
                                <a href="{{ $button['url'] ?? '#' }}" class="hero1-btn-primary">
                                    @if (!empty($button['icon']))
                                        <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                    @endif
                                    @if (!empty($button['text']))
                                        <span>{{ $button['text'] }}</span>
                                    @endif
                                </a>
                            @endif
                        @endforeach
                    </div>
                </div>

                {{-- Image Section --}}
                <div class="hero1-image-section animate-fade-in-up delay-300">
                    <div class="hero1-image-container">
                        {{-- Main Image --}}
                        <div class="hero1-main-image">
                            <img src="{{ $hero['hero_image_url'] ?? ($hero['hero_image'] ?? 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600&h=500&fit=crop') }}"
                                alt="Professional Laundry Service" loading="lazy">
                        </div>

                        {{-- Floating Cards --}}
                        @foreach ($hero['floating_cards'] ?? [] as $index => $card)
                            <div
                                class="hero1-float-card hero1-float-card-{{ $index + 1 }} animate-bounce-soft {{ $index > 0 ? 'delay-300' : '' }}">
                                <div
                                    class="hero1-float-icon {{ $index === 0 ? 'hero1-float-icon-success' : 'hero1-float-icon-primary' }}">
                                    <x-icon icon="{{ $card['icon'] ?? 'heroicons:check' }}"
                                        class="w-6 h-6 text-white" />
                                </div>
                                <div>
                                    <p class="hero1-float-title">{{ $card['title'] ?? '' }}</p>
                                    <p class="hero1-float-subtitle">{{ $card['subtitle'] ?? '' }}</p>
                                </div>
                            </div>
                        @endforeach

                        {{-- Decorative Circles --}}
                        <div class="hero1-deco-circle hero1-deco-circle-1"></div>
                        <div class="hero1-deco-circle hero1-deco-circle-2"></div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Bottom Curve --}}
        <div class="hero1-bottom-curve">
            <svg viewBox="0 0 1440 100" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
                <path d="M0 100V0C240 60 480 90 720 90C960 90 1200 60 1440 0V100H0Z" class="hero1-curve-fill" />
            </svg>
        </div>
    </section>

    
</div>