<?php
use Livewire\Component;
?>

<div>
    <section class="relative min-h-screen flex items-center gradient-hero overflow-hidden"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        {{-- Floating Elements --}}
        <div class="absolute inset-0 overflow-hidden">
            <div class="floating-element w-64 h-64 bg-white top-20 -left-32 animate-float"></div>
            <div class="floating-element w-96 h-96 bg-white bottom-20 -right-48 animate-float delay-300"></div>
            <div class="floating-element w-32 h-32 bg-white top-1/2 left-1/4 animate-float delay-500"></div>
        </div>

        <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-32">
            <div class="grid lg:grid-cols-2 gap-12 items-center">
                {{-- Hero Content --}}
                <div class="text-white">
                    <span
                        class="inline-block px-4 py-2 rounded-full bg-white/20 text-sm font-medium mb-6 animate-fade-in-down">
                        {{ $hero['badge'] }}
                    </span>
                    <h1 class="text-4xl sm:text-5xl lg:text-6xl font-bold leading-tight mb-6 animate-fade-in-up">
                        {{ $hero['title'] }}
                        <span class="block text-secondary-300">{{ $hero['subtitle'] }}</span>
                    </h1>
                    <p class="text-lg text-white/90 mb-8 max-w-lg animate-fade-in-up delay-200">
                        {{ $hero['description'] }}
                    </p>
                    <div class="flex flex-wrap gap-4 animate-fade-in-up delay-300">
                        @foreach ($hero['buttons'] ?? [] as $index => $button)
                            @if ($button['is_transparent'] ?? false)
                                <a href="{{ $button['url'] ?? '#' }}"
                                    class="btn btn-outline-white flex items-center gap-2">
                                    @if (!empty($button['icon']))
                                        <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                    @endif
                                    @if (!empty($button['text']))
                                        <span>{{ $button['text'] }}</span>
                                    @endif
                                </a>
                            @else
                                <a href="{{ $button['url'] ?? '#' }}" class="btn btn-white flex items-center gap-2">
                                    @if (!empty($button['icon']))
                                        <x-icon icon="{{ $button['icon'] }}" class="w-5 h-5" />
                                    @endif
                                    @if (!empty($button['text']))
                                        <span>{{ $button['text'] }}</span>
                                    @endif
                                </a>
                            @endif
                        @endforeach
                    </div>
                </div>

                {{-- Hero Image --}}
                <div class="hidden lg:block animate-fade-in-right delay-400">
                    <div class="relative">
                        <div class="absolute inset-0 bg-white/10 rounded-3xl transform rotate-6"></div>
                        <img src="{{ $hero['hero_image_url'] ?? ($hero['hero_image'] ?? 'https://images.unsplash.com/photo-1545173168-9f1947eebb7f?w=600&h=500&fit=crop') }}"
                            alt="Professional Laundry Service"
                            class="relative rounded-3xl shadow-2xl w-full object-cover" loading="lazy">

                        {{-- Floating Cards --}}
                        @foreach ($hero['floating_cards'] ?? [] as $index => $card)
                            <div
                                class="hero-float-card hero-float-card-{{ $index + 1 }} animate-bounce-soft {{ $index > 0 ? 'delay-300' : '' }}">
                                <div
                                    class="hero-float-icon {{ $index === 0 ? 'hero-float-icon-success' : 'hero-float-icon-primary' }}">
                                    <x-icon icon="{{ $card['icon'] ?? 'heroicons:check' }}" class="w-6 h-6" />
                                </div>
                                <div>
                                    <p class="hero-float-title">{{ $card['title'] ?? '' }}</p>
                                    <p class="hero-float-subtitle">{{ $card['subtitle'] ?? '' }}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>

            {{-- Stats --}}
            @if (!empty($hero['stats']))
                <div class="hero-stats-grid mt-16 grid grid-cols-2 md:grid-cols-4 gap-4 animate-fade-in-up delay-500">
                    @foreach ($hero['stats'] as $stat)
                        <div class="hero-stat-item glass rounded-xl">
                            @if (!empty($stat['icon']))
                                <div class="hero-stat-icon">
                                    <x-icon icon="{{ $stat['icon'] }}" class="w-8 h-8" />
                                </div>
                            @endif
                            <div class="hero-stat-content">
                                <div class="hero-stat-value" data-counter="{{ $stat['value'] }}">{{ $stat['value'] }}
                                </div>
                                <div class="hero-stat-label">{{ $stat['label'] }}</div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>

        {{-- Wave Decoration --}}
        <div class="absolute bottom-0 left-0 right-0">
            <svg viewBox="0 0 1440 120" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M0 120L60 110C120 100 240 80 360 70C480 60 600 60 720 65C840 70 960 80 1080 85C1200 90 1320 90 1380 90L1440 90V120H1380C1320 120 1200 120 1080 120C960 120 840 120 720 120C600 120 480 120 360 120C240 120 120 120 60 120H0Z"
                    fill="white" class="dark:fill-gray-900" />
            </svg>
        </div>
    </section>

    
</div>