<?php
use Livewire\Component;
?>

<div>
    


    <section id="app-download"
        class="app-minimal-section section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        <div class="app-minimal-line"></div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid lg:grid-cols-2 gap-12 lg:gap-16 items-center">
                {{-- Content Column --}}
                <div class="scroll-animate order-2 lg:order-1" data-animation="fade-right">
                    <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>

                    <h2 class="text-3xl lg:text-4xl font-bold text-gray-900 dark:text-white mb-3 leading-tight">
                        {{ $section['title'] }}
                    </h2>

                    @if (!empty($section['subtitle']))
                        <p class="text-lg text-primary-600 dark:text-primary-400 font-medium mb-3">
                            {{ $section['subtitle'] }}
                        </p>
                    @endif

                    @if (!empty($section['description']))
                        <p class="text-gray-600 dark:text-gray-300 mb-6">
                            {!! strip_tags($section['description']) !!}
                        </p>
                    @endif

                    {{-- App Features --}}
                    @if (count($items) > 0)
                        <div class="grid sm:grid-cols-2 gap-4 mb-6">
                            @foreach ($items as $feature)
                                <div class="app-minimal-feature">
                                    <div class="app-minimal-feature-icon">
                                        <x-icon icon="{{ $feature['icon'] ?? 'heroicons:check' }}"
                                            class="w-5 h-5 text-white" />
                                    </div>
                                    <div>
                                        <h4 class="font-semibold text-gray-900 dark:text-white">
                                            {{ $feature['title'] ?? '' }}</h4>
                                        @if (!empty($feature['description']))
                                            <p class="text-gray-600 dark:text-gray-400 text-sm">
                                                {{ $feature['description'] }}</p>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    {{-- Download Buttons --}}
                    @php
                        $ctaButtons = $section['cta_buttons'] ?? [];
                        if (
                            empty($ctaButtons) &&
                            (!empty($section['app_store_url']) || !empty($section['play_store_url']))
                        ) {
                            $ctaButtons = [];
                            if (!empty($section['app_store_url'])) {
                                $ctaButtons[] = [
                                    'icon' => 'mdi:apple',
                                    'url' => $section['app_store_url'],
                                    'text_top' => $section['app_store_text_top'] ?? 'Download on the',
                                    'text_main' => $section['app_store_text_main'] ?? 'App Store',
                                ];
                            }
                            if (!empty($section['play_store_url'])) {
                                $ctaButtons[] = [
                                    'icon' => 'mdi:google-play',
                                    'url' => $section['play_store_url'],
                                    'text_top' => $section['play_store_text_top'] ?? 'Get it on',
                                    'text_main' => $section['play_store_text_main'] ?? 'Google Play',
                                ];
                            }
                        }
                    @endphp
                    @if (count($ctaButtons) > 0)
                        <div class="flex flex-wrap gap-3 mb-6">
                            @foreach ($ctaButtons as $index => $button)
                                @if (!empty($button['url']))
                                    <a href="{{ $button['url'] }}" target="_blank" rel="noopener"
                                        class="store-minimal {{ $index === 0 ? 'store-minimal-primary' : 'store-minimal-secondary' }}">
                                        <x-icon icon="{{ $button['icon'] ?? 'heroicons:device-phone-mobile' }}"
                                            class="w-6 h-6" />
                                        <div class="text-left">
                                            <div class="text-[10px] opacity-60 leading-tight">
                                                {{ $button['text_top'] ?? '' }}</div>
                                            <div class="text-sm font-semibold leading-tight">
                                                {{ $button['text_main'] ?? '' }}</div>
                                        </div>
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    @endif

                    {{-- Stats Row --}}
                    @php $appStats = $section['app_stats'] ?? []; @endphp
                    @if (count($appStats) > 0)
                        <div class="flex mb-6">
                            @foreach ($appStats as $stat)
                                <div class="app-minimal-stat">
                                    <div class="flex items-center justify-center gap-1">
                                        @if (!empty($stat['icon']))
                                            <x-icon icon="{{ $stat['icon'] }}" class="w-5 h-5 text-primary-500" />
                                        @endif
                                        <span
                                            class="text-xl font-bold text-gray-900 dark:text-white">{{ $stat['value'] ?? '' }}</span>
                                    </div>
                                    <div class="text-xs text-gray-500 dark:text-gray-400">{{ $stat['label'] ?? '' }}
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    {{-- Trusted Users --}}
                    @php
                        $trustedUsers = $section['trusted_users'] ?? [];
                        $trustedUsersEnabled = $trustedUsers['enabled'] ?? true;
                        $userAvatars = $trustedUsers['avatars'] ?? ($section['user_avatars'] ?? []);
                        if (empty($userAvatars)) {
                            $userAvatars = [
                                ['image' => 'https://i.pravatar.cc/100?img=1', 'name' => 'User 1'],
                                ['image' => 'https://i.pravatar.cc/100?img=2', 'name' => 'User 2'],
                                ['image' => 'https://i.pravatar.cc/100?img=3', 'name' => 'User 3'],
                                ['image' => 'https://i.pravatar.cc/100?img=4', 'name' => 'User 4'],
                                ['image' => 'https://i.pravatar.cc/100?img=5', 'name' => 'User 5'],
                            ];
                        }
                        $trustedUsersCount = '100K+';
                        if (!empty($appStats)) {
                            $lastStat = end($appStats);
                            $trustedUsersCount = $lastStat['value'] ?? $trustedUsersCount;
                        }
                        $trustedTitle =
                            $trustedUsers['title'] ?? ($section['trusted_users_title'] ?? 'Trusted by %count% users');
                        $trustedTitle = str_replace('%count%', $trustedUsersCount, $trustedTitle);
                        $trustedSubtitle =
                            $trustedUsers['subtitle'] ??
                            ($section['trusted_users_subtitle'] ?? 'Join thousands of satisfied customers');
                    @endphp
                    @if ($trustedUsersEnabled)
                        <div class="flex items-center gap-3 mb-6">
                            <div class="flex -space-x-2">
                                @foreach (array_slice($userAvatars, 0, 5) as $index => $avatar)
                                    @php
                                        $avatarUrl = is_array($avatar)
                                            ? $avatar['image_url'] ?? ($avatar['image'] ?? null)
                                            : $avatar;
                                        $avatarName = is_array($avatar) ? $avatar['name'] ?? 'User' : 'User';
                                    @endphp
                                    @if ($avatarUrl)
                                        <img src="{{ $avatarUrl }}" alt="{{ $avatarName }}"
                                            title="{{ $avatarName }}"
                                            class="w-10 h-10 rounded-full border-2 border-white dark:border-gray-800 object-cover"
                                            loading="lazy">
                                    @endif
                                @endforeach
                            </div>
                            <div class="flex-1">
                                <p class="text-sm font-medium text-gray-900 dark:text-white">{{ $trustedTitle }}</p>
                                <p class="text-xs text-gray-600 dark:text-gray-400">{{ $trustedSubtitle }}</p>
                            </div>
                        </div>
                    @endif

                    {{-- QR Code --}}
                    @php $qrCodeUrl = $section['qr_code_url'] ?? $section['qr_code'] ?? null; @endphp
                    @if ($qrCodeUrl)
                        <div class="app-minimal-qr">
                            <div class="app-minimal-qr-image flex-shrink-0">
                                <img src="{{ $qrCodeUrl }}" alt="QR Code" class="w-14 h-14 object-contain"
                                    loading="lazy">
                            </div>
                            <div>
                                <p class="app-minimal-qr-title text-sm font-semibold">
                                    {{ $section['qr_label'] ?? 'Scan to Download' }}</p>
                                <p class="app-minimal-qr-desc text-xs">
                                    {{ $section['qr_description'] ?? 'Point your camera' }}</p>
                            </div>
                        </div>
                    @endif
                </div>

                {{-- Phone Column --}}
                <div class="scroll-animate flex justify-center order-1 lg:order-2" data-animation="fade-left">
                    @php $appImageUrl = $section['app_image_url'] ?? $section['app_image'] ?? null; @endphp

                    <div class="app-minimal-float">
                        @if ($appImageUrl)
                            <div class="app-minimal-phone max-w-[260px]">
                                <div class="app-minimal-phone-inner">
                                    <img src="{{ $appImageUrl }}" alt="{{ $section['title'] }}" class="w-full h-auto"
                                        loading="lazy">
                                </div>
                            </div>
                        @else
                            <div class="app-minimal-phone max-w-[260px]">
                                <div class="app-minimal-phone-inner aspect-[9/19] flex items-center justify-center">
                                    <x-icon icon="heroicons:device-phone-mobile"
                                        class="w-16 h-16 text-gray-300 dark:text-gray-600" />
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>