<?php
use Livewire\Component;
?>

<section id="how-it-works" class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Header --}}
        <div class="text-center mb-16">
            <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
            <h2 class="section-title">{{ $section['title'] }}</h2>
            <p class="section-subtitle">{{ $section['subtitle'] }}</p>
        </div>

        {{-- Process Steps --}}
        <div class="grid md:grid-cols-4 gap-8">
            @foreach ($items as $index => $step)
                <div class="scroll-animate process-step text-center">
                    {{-- Step Number --}}
                    <div
                        class="relative inline-flex items-center justify-center w-16 h-16 rounded-full gradient-primary text-white text-2xl font-bold mb-6">
                        {{ $step['step'] }}
                        <div class="absolute inset-0 rounded-full gradient-primary opacity-20 animate-ping"></div>
                    </div>

                    {{-- Icon --}}
                    <div
                        class="w-20 h-20 mx-auto mb-6 rounded-2xl bg-primary-50 dark:bg-primary-900/30 flex items-center justify-center">
                        <x-icon icon="{{ $step['icon'] ?? 'heroicons:home' }}" class="w-10 h-10 text-primary-600" />
                    </div>

                    {{-- Content --}}
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">{{ $step['title'] }}</h3>
                    <p class="text-gray-600 dark:text-gray-400">{{ $step['description'] }}</p>
                </div>
            @endforeach
        </div>
    </div>
</section>