<?php
use App\Livewire\LivewireBaseComponent;
use App\Models\WebsiteBuilder;
use App\Models\ThemeSection;
use Illuminate\Support\Facades\File;
?>

<div>
<div class="section-preview-wrapper">
    @if ($this->componentExists())
        @livewire($this->getComponentName(), $this->getSectionProps(), key($sectionKey . '-' . $layoutName))
    @else
        <div class="section-preview-error">
            <div class="error-content">
                <svg xmlns="http://www.w3.org/2000/svg" class="error-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                </svg>
                <h3>Layout Not Found</h3>
                <p>The layout <strong>{{ $layoutName }}</strong> for section <strong>{{ $sectionKey }}</strong> does not exist.</p>
            </div>
        </div>
    @endif
</div>


</div>