<?php
use Livewire\Component;
?>

<section id="testimonials" class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Header --}}
        <div class="text-center mb-16">
            <span class="badge badge-primary mb-4">{{ $section['badge'] ?? 'Testimonials' }}</span>
            <h2 class="section-title">{{ $section['title'] ?? 'What Our Customers Say' }}</h2>
            <p class="section-subtitle">{{ $section['subtitle'] ?? "Don't just take our word for it." }}</p>
        </div>

        {{-- Testimonial Slider --}}
        <div class="relative overflow-hidden">
            <div id="testimonial-slider" class="flex transition-transform duration-500 ease-out">
                @foreach ($items as $index => $testimonial)
                    <div class="testimonial-slide w-full flex-shrink-0 px-4">
                        <div class="testimonial-card max-w-3xl mx-auto text-center">
                            {{-- Rating --}}
                            <div class="star-rating justify-center mb-6">
                                @for ($i = 0; $i < ($testimonial['rating'] ?? 5); $i++)
                                    <x-icon icon="heroicons:star-solid" class="w-6 h-6 star" />
                                @endfor
                            </div>

                            {{-- Quote --}}
                            <p class="text-xl text-gray-700 dark:text-gray-300 mb-8 leading-relaxed">
                                "{{ $testimonial['text'] ?? 'Great service and excellent quality!' }}"</p>

                            {{-- Author --}}
                            <div class="flex items-center justify-center">
                                @if (!empty($testimonial['avatar_url']) || !empty($testimonial['avatar']))
                                    <img src="{{ $testimonial['avatar_url'] ?? $testimonial['avatar'] }}"
                                        alt="{{ $testimonial['name'] ?? 'Customer' }}"
                                        class="w-14 h-14 rounded-full object-cover mr-4" loading="lazy">
                                @else
                                    <div
                                        class="w-14 h-14 rounded-full bg-primary-100 dark:bg-primary-900/30 flex items-center justify-center mr-4">
                                        <span
                                            class="text-xl font-bold text-primary-600">{{ substr($testimonial['name'] ?? 'C', 0, 1) }}</span>
                                    </div>
                                @endif
                                <div class="text-left">
                                    <p class="font-semibold text-gray-900 dark:text-white">
                                        {{ $testimonial['name'] ?? 'Happy Customer' }}</p>
                                    <p class="text-sm text-gray-600 dark:text-gray-400">{{ $testimonial['role'] ?? 'Customer' }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            {{-- Navigation Arrows --}}
            <button id="testimonial-prev"
                class="absolute left-0 top-1/2 -translate-y-1/2 w-12 h-12 rounded-full bg-white dark:bg-gray-700 shadow-lg flex items-center justify-center hover:bg-gray-50 dark:hover:bg-gray-600 transition-colors">
                <x-icon icon="heroicons:chevron-left" class="w-6 h-6 text-gray-600 dark:text-gray-300" />
            </button>
            <button id="testimonial-next"
                class="absolute right-0 top-1/2 -translate-y-1/2 w-12 h-12 rounded-full bg-white dark:bg-gray-700 shadow-lg flex items-center justify-center hover:bg-gray-50 dark:hover:bg-gray-600 transition-colors">
                <x-icon icon="heroicons:chevron-right" class="w-6 h-6 text-gray-600 dark:text-gray-300" />
            </button>
        </div>

        {{-- Dots --}}
        <div class="flex justify-center gap-2 mt-8">
            @foreach ($items as $index => $testimonial)
                <button
                    class="testimonial-dot w-3 h-3 rounded-full transition-all duration-300 {{ $index === 0 ? 'bg-primary-600 w-8' : 'bg-gray-300 dark:bg-gray-600 hover:bg-gray-400' }}"></button>
            @endforeach
        </div>
    </div>
</section>