<?php
use Livewire\Component;
?>

<section class="pricing-minimal-section {{ $isWhiteBackground ? 'pricing-minimal-white' : 'pricing-minimal-gray' }}" @if($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <span class="pricing-minimal-badge">{{ $section['badge'] }}</span>
            <h2 class="pricing-minimal-title">{{ $section['title'] }}</h2>
            <p class="pricing-minimal-subtitle">{{ $section['subtitle'] }}</p>
        </div>
        <div class="pricing-minimal-grid">
            @foreach ($items as $index => $plan)
                <div class="pricing-minimal-card {{ $plan['popular'] ? 'pricing-minimal-card-popular' : '' }}">
                    @if ($plan['popular'])
                        <div class="pricing-minimal-popular-badge">{{ $section['popular_badge'] }}</div>
                    @endif
                    <div class="pricing-minimal-header">
                        <h3 class="pricing-minimal-name">{{ $plan['name'] }}</h3>
                        <p class="pricing-minimal-desc">{{ $plan['description'] }}</p>
                    </div>
                    <div class="pricing-minimal-price-box">
                        <span class="pricing-minimal-currency">{{ $section['currency_symbol'] }}</span>
                        <span class="pricing-minimal-price">{{ $plan['price'] }}</span>
                        <span class="pricing-minimal-period">/{{ $plan['period'] }}</span>
                    </div>
                    <div class="pricing-minimal-divider"></div>
                    <ul class="pricing-minimal-features">
                        @foreach ($plan['features'] as $feature)
                            <li class="pricing-minimal-feature {{ $feature['is_included'] ? '' : 'pricing-minimal-feature-disabled' }}">
                                <div class="pricing-minimal-check">
                                    <x-icon icon="{{ $feature['icon'] ?? 'lucide:check' }}" class="pricing-minimal-check-icon" />
                                </div>
                                <span>{{ $feature['text'] }}</span>
                            </li>
                        @endforeach
                    </ul>
                    <a href="{{ $section['cta_button_url'] ?? '#contact' }}" class="pricing-minimal-btn">{{ $section['cta_button'] }}</a>
                </div>
            @endforeach
        </div>
    </div>
</section>

</div>