<?php
use Livewire\Component;
?>

<div>
    

    <section id="team"
        class="section {{ $isWhiteBackground ? 'bg-white dark:bg-gray-800' : 'bg-gray-50 dark:bg-gray-900' }}"
        @if ($this->getCustomPaddingStyle()) style="{{ $this->getCustomPaddingStyle() }}" @endif>
        <div class="team-overlap-container max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Background Shapes --}}
            <div class="team-overlap-bg-shape team-overlap-bg-shape-1"></div>
            <div class="team-overlap-bg-shape team-overlap-bg-shape-2"></div>

            {{-- Section Header --}}
            <div class="text-center mb-20 scroll-animate relative z-10" data-animation="fade-up">
                @if (!empty($section['badge']))
                    <span class="badge badge-primary mb-4">{{ $section['badge'] }}</span>
                @endif

                <h2 class="section-title">
                    <span class="team-overlap-header-shapes">{{ $section['title'] }}</span>
                </h2>

                @if (!empty($section['subtitle']))
                    <p class="section-subtitle">{{ $section['subtitle'] }}</p>
                @endif
            </div>

            {{-- Team Grid --}}
            <div class="grid sm:grid-cols-2 lg:grid-cols-4 gap-8 relative z-10">
                @foreach ($items as $index => $member)
                    <div class="team-overlap-card scroll-animate" data-animation="fade-up"
                        style="animation-delay: {{ $index * 150 }}ms">
                        {{-- Morphing Image --}}
                        <div class="team-overlap-image-wrapper">
                            <div class="team-overlap-image-shape" style="animation-delay: {{ $index * 0.5 }}s"></div>
                            @php
                                $imageUrl = $member['image_url'] ?? ($member['image'] ?? null);
                                $defaultPlaceholder =
                                    'https://ui-avatars.com/api/?name=' .
                                    urlencode($member['name'] ?? 'Team') .
                                    '&size=300&background=random&color=fff&bold=true';
                            @endphp
                            <img src="{{ $imageUrl ?: $defaultPlaceholder }}" alt="{{ $member['name'] ?? '' }}"
                                class="team-overlap-image" style="animation-delay: {{ $index * 0.5 }}s" loading="lazy">
                        </div>

                        {{-- Content Card --}}
                        <div class="team-overlap-content">
                            <div class="team-overlap-corner team-overlap-corner-tl"></div>
                            <div class="team-overlap-corner team-overlap-corner-br"></div>

                            <h3 class="team-overlap-name">{{ $member['name'] ?? '' }}</h3>

                            @if (!empty($member['position']) || !empty($member['role']))
                                <p class="team-overlap-position">{{ $member['position'] ?? $member['role'] }}</p>
                            @endif

                            @if (!empty($member['bio']))
                                <p class="team-overlap-bio line-clamp-2">{{ $member['bio'] }}</p>
                            @endif

                            @if (!empty($member['social_links']))
                                <div class="team-overlap-social">
                                    @foreach ($member['social_links'] as $social)
                                        <a href="{{ $social['url'] ?? '#' }}" target="_blank" rel="noopener">
                                            <x-icon icon="{{ $social['icon'] ?? 'mdi:link' }}" class="w-4 h-4" />
                                        </a>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
</div>