<?php
use Livewire\Component;
?>

<div>
<section class="features-hexagon-section {{ $isWhiteBackground ? 'features-hexagon-white' : 'features-hexagon-gray' }}" @if($this->getPaddingStyle()) style="{{ $this->getPaddingStyle() }}" @endif>
    {{-- Background Hexagons --}}
    <div class="features-hexagon-bg">
        <div class="features-hexagon-bg-shape features-hexagon-bg-shape-1"></div>
        <div class="features-hexagon-bg-shape features-hexagon-bg-shape-2"></div>
        <div class="features-hexagon-bg-shape features-hexagon-bg-shape-3"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        <div class="features-hexagon-grid">
            @foreach ($items as $index => $feature)
                <div class="features-hexagon-item scroll-animate" style="animation-delay: {{ $index * 100 }}ms">
                    {{-- Hexagon Shape --}}
                    <div class="features-hexagon-shape">
                        <div class="features-hexagon-shape-inner">
                            <x-icon icon="{{ $feature['icon'] ?? 'heroicons:heart' }}" class="w-8 h-8" />
                        </div>
                    </div>

                    {{-- Content --}}
                    <div class="features-hexagon-content">
                        <h3 class="features-hexagon-title">{{ $feature['title'] }}</h3>
                        <p class="features-hexagon-desc">{{ $feature['description'] }}</p>
                    </div>

                    {{-- Connecting Line --}}
                    @if ($index < count($items) - 1)
                        <div class="features-hexagon-connector"></div>
                    @endif
                </div>
            @endforeach
        </div>
    </div>
</section>


</div>